/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.Serializable;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.spark.ml.tree.impl.BaggedPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class BaggedPoint$
implements Serializable {
    public static final BaggedPoint$ MODULE$ = new BaggedPoint$();

    public <Datum> double $lessinit$greater$default$3() {
        return 1.0;
    }

    public <Datum> RDD<BaggedPoint<Datum>> convertToBaggedRDD(RDD<Datum> input, double subsamplingRate, int numSubsamples, boolean withReplacement, Function1<Datum, Object> extractSampleWeight, long seed) {
        if (withReplacement) {
            return this.convertToBaggedRDDSamplingWithReplacement(input, subsamplingRate, numSubsamples, extractSampleWeight, seed);
        }
        if (subsamplingRate == 1.0) {
            return this.convertToBaggedRDDWithoutSampling(input, numSubsamples, extractSampleWeight);
        }
        return this.convertToBaggedRDDSamplingWithoutReplacement(input, subsamplingRate, numSubsamples, extractSampleWeight, seed);
    }

    public <Datum> Function1<Datum, Object> convertToBaggedRDD$default$5() {
        return (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)BaggedPoint$.$anonfun$convertToBaggedRDD$default$5$1(x$1));
    }

    public <Datum> long convertToBaggedRDD$default$6() {
        return Utils$.MODULE$.random().nextLong();
    }

    private <Datum> RDD<BaggedPoint<Datum>> convertToBaggedRDDSamplingWithoutReplacement(RDD<Datum> input, double subsamplingRate, int numSubsamples, Function1<Datum, Object> extractSampleWeight, long seed) {
        return input.mapPartitionsWithIndex((Function2 & Serializable)(partitionIndex, instances) -> BaggedPoint$.$anonfun$convertToBaggedRDDSamplingWithoutReplacement$1(seed, numSubsamples, subsamplingRate, extractSampleWeight, BoxesRunTime.unboxToInt((Object)partitionIndex), instances), input.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(BaggedPoint.class));
    }

    private <Datum> RDD<BaggedPoint<Datum>> convertToBaggedRDDSamplingWithReplacement(RDD<Datum> input, double subsample, int numSubsamples, Function1<Datum, Object> extractSampleWeight, long seed) {
        return input.mapPartitionsWithIndex((Function2 & Serializable)(partitionIndex, instances) -> BaggedPoint$.$anonfun$convertToBaggedRDDSamplingWithReplacement$1(subsample, seed, numSubsamples, extractSampleWeight, BoxesRunTime.unboxToInt((Object)partitionIndex), instances), input.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(BaggedPoint.class));
    }

    private <Datum> RDD<BaggedPoint<Datum>> convertToBaggedRDDWithoutSampling(RDD<Datum> input, int numSubsamples, Function1<Datum, Object> extractSampleWeight) {
        return input.mapPartitions((Function1 & Serializable)instances -> {
            int[] subsampleCounts = (int[])Array$.MODULE$.fill(numSubsamples, (Function0)(JFunction0.mcI.sp & Serializable)() -> 1, (ClassTag)ClassTag$.MODULE$.Int());
            return instances.map((Function1 & Serializable)instance -> new BaggedPoint<Object>(instance, subsampleCounts, BoxesRunTime.unboxToDouble((Object)extractSampleWeight.apply(instance))));
        }, input.mapPartitions$default$2(), ClassTag$.MODULE$.apply(BaggedPoint.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BaggedPoint$.class);
    }

    public static final /* synthetic */ double $anonfun$convertToBaggedRDD$default$5$1(Object x$1) {
        return 1.0;
    }

    public static final /* synthetic */ Iterator $anonfun$convertToBaggedRDDSamplingWithoutReplacement$1(long seed$1, int numSubsamples$1, double subsamplingRate$1, Function1 extractSampleWeight$1, int partitionIndex, Iterator instances) {
        XORShiftRandom rng = new XORShiftRandom();
        rng.setSeed(seed$1 + (long)partitionIndex + 1L);
        return instances.map((Function1 & Serializable)instance -> {
            int[] subsampleCounts = new int[numSubsamples$1];
            for (int subsampleIndex = 0; subsampleIndex < numSubsamples$1; ++subsampleIndex) {
                if (!(rng.nextDouble() < subsamplingRate$1)) continue;
                subsampleCounts[subsampleIndex] = 1;
            }
            return new BaggedPoint<Object>(instance, subsampleCounts, BoxesRunTime.unboxToDouble((Object)extractSampleWeight$1.apply(instance)));
        });
    }

    public static final /* synthetic */ Iterator $anonfun$convertToBaggedRDDSamplingWithReplacement$1(double subsample$1, long seed$2, int numSubsamples$2, Function1 extractSampleWeight$2, int partitionIndex, Iterator instances) {
        PoissonDistribution poisson = new PoissonDistribution(subsample$1);
        poisson.reseedRandomGenerator(seed$2 + (long)partitionIndex + 1L);
        return instances.map((Function1 & Serializable)instance -> {
            int[] subsampleCounts = new int[numSubsamples$2];
            for (int subsampleIndex = 0; subsampleIndex < numSubsamples$2; ++subsampleIndex) {
                subsampleCounts[subsampleIndex] = poisson.sample();
            }
            return new BaggedPoint<Object>(instance, subsampleCounts, BoxesRunTime.unboxToDouble((Object)extractSampleWeight$2.apply(instance)));
        });
    }

    private BaggedPoint$() {
    }
}

