/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.KeyValueChecksumEncoder$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangeDataReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangeDataReader$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\b\u0010\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!q\u0004A!A!\u0002\u0013A\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\")!\u000b\u0001C\u0001'\"9a\f\u0001b\u0001\n#z\u0006BB6\u0001A\u0003%\u0001\rC\u0003m\u0001\u0011\u0005SN\u0001\u0013I\t\u001a\u001b&)Y2lK\u0012\u001cF/\u0019;f'R|'/Z\"iC:<W\rR1uCJ+\u0017\rZ3s\u0015\t\u0001\u0012#A\u0003ti\u0006$XM\u0003\u0002\u0013'\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003)U\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Y9\u0012aA:rY*\u0011\u0001$G\u0001\u0006gB\f'o\u001b\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011\"\u001b\u0005y\u0011B\u0001\u0012\u0010\u0005i\u0019F/\u0019;f'R|'/Z\"iC:<W\rR1uCJ+\u0017\rZ3s\u0003\u001d\u0019Ho\u001c:f\u0013\u0012\u0004\"\u0001I\u0013\n\u0005\u0019z!\u0001D*uCR,7\u000b^8sK&#\u0017A\u00014n!\tIC&D\u0001+\u0015\tY\u0013#A\u0007dQ\u0016\u001c7\u000e]8j]RLgnZ\u0005\u0003[)\u0012Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/A\u0007ti\u0006$X\rT8dCRLwN\u001c\t\u0003aUj\u0011!\r\u0006\u0003eM\n!AZ:\u000b\u0005QJ\u0012A\u00025bI>|\u0007/\u0003\u00027c\t!\u0001+\u0019;i\u00031\u0019H/\u0019:u-\u0016\u00148/[8o!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0011auN\\4\u0002\u0015\u0015tGMV3sg&|g.\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011\u0011\tR\u0007\u0002\u0005*\u00111iF\u0001\u0003S>L!!\u0012\"\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017!C6fsN\u001b\u0007.Z7b!\tA5*D\u0001J\u0015\tQU#A\u0003usB,7/\u0003\u0002M\u0013\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0017Y\fG.^3TG\",W.Y\u0001\ngR|'/Z\"p]\u001a\u0004\"\u0001\t)\n\u0005E{!AD*uCR,7\u000b^8sK\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015Q+fk\u0016-Z5ncV\f\u0005\u0002!\u0001!)1E\u0003a\u0001I!)qE\u0003a\u0001Q!)aF\u0003a\u0001_!)qG\u0003a\u0001q!)aH\u0003a\u0001q!)qH\u0003a\u0001\u0001\")aI\u0003a\u0001\u000f\")QJ\u0003a\u0001\u000f\")aJ\u0003a\u0001\u001f\u0006y1\r[1oO\u0016dwnZ*vM\u001aL\u00070F\u0001a!\t\t\u0007N\u0004\u0002cMB\u00111MO\u0007\u0002I*\u0011Q-H\u0001\u0007yI|w\u000e\u001e \n\u0005\u001dT\u0014A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!a\u001a\u001e\u0002!\rD\u0017M\\4fY><7+\u001e4gSb\u0004\u0013aB4fi:+\u0007\u0010\u001e\u000b\u0002]B1\u0011h\\9zsbJ!\u0001\u001d\u001e\u0003\rQ+\b\u000f\\35!\t\u0011XO\u0004\u0002!g&\u0011AoD\u0001\u000b%\u0016\u001cwN\u001d3UsB,\u0017B\u0001<x\u0005\u00151\u0016\r\\;f\u0013\tA(HA\u0006F]VlWM]1uS>t\u0007C\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005y,\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0007\u0005\u00051PA\u0005V]N\fg-\u001a*po\u0002")
public class HDFSBackedStateStoreChangeDataReader
extends StateStoreChangeDataReader {
    private final StructType keySchema;
    private final StructType valueSchema;
    private final StateStoreConf storeConf;
    private final String changelogSuffix;

    @Override
    public String changelogSuffix() {
        return this.changelogSuffix;
    }

    public Tuple4<Enumeration.Value, UnsafeRow, UnsafeRow, Object> getNext() {
        StateStoreChangelogReader reader = this.currentChangelogReader();
        if (reader == null) {
            return null;
        }
        Tuple3 tuple3 = (Tuple3)reader.next();
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Enumeration.Value recordType = (Enumeration.Value)tuple3._1();
        byte[] keyArray = (byte[])tuple3._2();
        byte[] valueArray = (byte[])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)recordType, (Object)keyArray, (Object)valueArray);
        Enumeration.Value recordType2 = (Enumeration.Value)tuple32._1();
        byte[] keyArray2 = (byte[])tuple32._2();
        byte[] valueArray2 = (byte[])tuple32._3();
        UnsafeRow keyRow = new UnsafeRow(this.keySchema.fields().length);
        if (valueArray2 == null) {
            byte[] originalKeyBytes = this.storeConf.rowChecksumEnabled() ? KeyValueChecksumEncoder$.MODULE$.decodeAndVerifyKeyRowWithChecksum(this.readVerifier(), keyArray2) : keyArray2;
            keyRow.pointTo(originalKeyBytes, originalKeyBytes.length);
            return new Tuple4((Object)recordType2, (Object)keyRow, null, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
        }
        keyRow.pointTo(keyArray2, keyArray2.length);
        UnsafeRow valueRow = new UnsafeRow(this.valueSchema.fields().length);
        byte[] originalValueBytes = this.storeConf.rowChecksumEnabled() ? KeyValueChecksumEncoder$.MODULE$.decodeAndVerifySingleValueRowWithChecksum(this.readVerifier(), keyArray2, valueArray2) : valueArray2;
        valueRow.pointTo(originalValueBytes, originalValueBytes.length / 8 * 8);
        return new Tuple4((Object)recordType2, (Object)keyRow, (Object)valueRow, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
    }

    public HDFSBackedStateStoreChangeDataReader(StateStoreId storeId, CheckpointFileManager fm, Path stateLocation, long startVersion, long endVersion, CompressionCodec compressionCodec, StructType keySchema, StructType valueSchema, StateStoreConf storeConf) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.storeConf = storeConf;
        super(storeId, fm, stateLocation, startVersion, endVersion, compressionCodec, storeConf, StateStoreChangeDataReader$.MODULE$.$lessinit$greater$default$8());
        this.changelogSuffix = "delta";
    }
}

