/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.MessageIssue;

public class MessageIssueException
extends RuntimeException {
    private static final long serialVersionUID = 1118210473728652711L;
    private final Message rpcMessage;
    private final List<MessageIssue> issues;

    public MessageIssueException(Message rpcMessage, MessageIssue issue) {
        this.rpcMessage = rpcMessage;
        this.issues = Collections.singletonList(issue);
    }

    public MessageIssueException(Message rpcMessage, Collection<MessageIssue> issues) {
        this.rpcMessage = rpcMessage;
        this.issues = Collections.unmodifiableList(new ArrayList<MessageIssue>(issues));
    }

    public MessageIssueException(Message rpcMessage, Stream<MessageIssue> issueStream) {
        this.rpcMessage = rpcMessage;
        this.issues = Collections.unmodifiableList(issueStream.collect(Collectors.toList()));
    }

    @Override
    public String getMessage() {
        return this.issues.stream().map(issue -> issue.getText()).collect(Collectors.joining("\n"));
    }

    public Message getRpcMessage() {
        return this.rpcMessage;
    }

    public List<MessageIssue> getIssues() {
        return this.issues;
    }
}

