/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.execution.streaming.state.BatchCommitTracker;
import org.apache.spark.sql.execution.streaming.state.DeactivateInstances;
import org.apache.spark.sql.execution.streaming.state.GetLaggingStoresForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLatestSnapshotVersionForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLocation;
import org.apache.spark.sql.execution.streaming.state.LogLaggingStateStores;
import org.apache.spark.sql.execution.streaming.state.ReportActiveInstance;
import org.apache.spark.sql.execution.streaming.state.ReportSnapshotUploaded;
import org.apache.spark.sql.execution.streaming.state.ReportStateStoreCommit;
import org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent;
import org.apache.spark.sql.execution.streaming.state.StartStateStoreCommitTrackingForBatch;
import org.apache.spark.sql.execution.streaming.state.StateStoreCommitValidationFailed;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StopCoordinator$;
import org.apache.spark.sql.execution.streaming.state.ValidateStateStoreCommitForBatch;
import org.apache.spark.sql.execution.streaming.state.VerifyIfInstanceActive;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\u000b\u0016\t\u0011B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0005\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001dY\u0005A1A\u0005\n1CaA\u0018\u0001!\u0002\u0013i\u0005bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007K\u0002\u0001\u000b\u0011B1\t\u000f\u0019\u0004!\u0019!C\u0005O\"1\u0001\u000e\u0001Q\u0001\n\tDq!\u001b\u0001C\u0002\u0013%!\u000e\u0003\u0004~\u0001\u0001\u0006Ia\u001b\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0011!\t\u0019\u0001\u0001Q\u0001\n\u0005\u0005\u0001bBA\u0003\u0001\u0011%\u0011q\u0001\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!a\r\u0001\t\u0013\t)DA\u000bTi\u0006$Xm\u0015;pe\u0016\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005Y9\u0012!B:uCR,'B\u0001\r\u001a\u0003%\u0019HO]3b[&twM\u0003\u0002\u001b7\u0005IQ\r_3dkRLwN\u001c\u0006\u00039u\t1a]9m\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0015Z\u0013\u0007\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y=j\u0011!\f\u0006\u0003]u\t1A\u001d9d\u0013\t\u0001TFA\u000bUQJ,\u0017\rZ*bM\u0016\u0014\u0006oY#oIB|\u0017N\u001c;\u0011\u0005I*T\"A\u001a\u000b\u0005Qj\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005Y\u001a$a\u0002'pO\u001eLgnZ\u0001\u0007eB\u001cWI\u001c<\u0016\u0003e\u0002\"\u0001\f\u001e\n\u0005mj#A\u0002*qG\u0016sg/A\u0004sa\u000e,eN\u001e\u0011\u0002\u000fM\fHnQ8oMV\tq\b\u0005\u0002A\u00056\t\u0011I\u0003\u000257%\u00111)\u0011\u0002\b'Fc5i\u001c8g\u0003!\u0019\u0018\u000f\\\"p]\u001a\u0004\u0013A\u0002\u001fj]&$h\bF\u0002H\u0013*\u0003\"\u0001\u0013\u0001\u000e\u0003UAQaN\u0003A\u0002eBQ!P\u0003A\u0002}\n\u0011\"\u001b8ti\u0006t7-Z:\u0016\u00035\u0003BAT*V16\tqJ\u0003\u0002Q#\u00069Q.\u001e;bE2,'B\u0001*(\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003)>\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002I-&\u0011q+\u0006\u0002\u0015'R\fG/Z*u_J,\u0007K]8wS\u0012,'/\u00133\u0011\u0005ecV\"\u0001.\u000b\u0005mk\u0012!C:dQ\u0016$W\u000f\\3s\u0013\ti&LA\rFq\u0016\u001cW\u000f^8s\u0007\u0006\u001c\u0007.\u001a+bg.dunY1uS>t\u0017AC5ogR\fgnY3tA\u0005\u00013\u000f^1uKN#xN]3MCR,7\u000f^+qY>\fG-\u001a3T]\u0006\u00048\u000f[8u+\u0005\t\u0007\u0003\u0002(T+\n\u0004\"\u0001S2\n\u0005\u0011,\"aE*oCB\u001c\bn\u001c;Va2|\u0017\rZ#wK:$\u0018!I:uCR,7\u000b^8sK2\u000bG/Z:u+Bdw.\u00193fINs\u0017\r]:i_R\u0004\u0013A\u00073fM\u0006,H\u000e^*oCB\u001c\bn\u001c;Va2|\u0017\rZ#wK:$X#\u00012\u00027\u0011,g-Y;miNs\u0017\r]:i_R,\u0006\u000f\\8bI\u00163XM\u001c;!\u0003M\u0011\u0017\r^2i\u0007>lW.\u001b;Ue\u0006\u001c7.\u001a:t+\u0005Y\u0007\u0003\u0002(TYj\u0004BAJ7po&\u0011an\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018\u0001B;uS2T\u0011\u0001^\u0001\u0005U\u00064\u0018-\u0003\u0002wc\n!Q+V%E!\t1\u00030\u0003\u0002zO\t!Aj\u001c8h!\tA50\u0003\u0002}+\t\u0011\")\u0019;dQ\u000e{W.\\5u)J\f7m[3s\u0003Q\u0011\u0017\r^2i\u0007>lW.\u001b;Ue\u0006\u001c7.\u001a:tA\u0005yB.Y:u\rVdGn\u00158baNDw\u000e\u001e'bOJ+\u0007o\u001c:u)&lW-T:\u0016\u0005\u0005\u0005\u0001\u0003\u0002(T_^\f\u0001\u0005\\1ti\u001a+H\u000e\\*oCB\u001c\bn\u001c;MC\u001e\u0014V\r]8siRKW.Z'tA\u0005\u00113\u000f[8vY\u0012\u001cun\u001c:eS:\fGo\u001c:SKB|'\u000f^*oCB\u001c\bn\u001c;MC\u001e,\"!!\u0003\u0011\u0007\u0019\nY!C\u0002\u0002\u000e\u001d\u0012qAQ8pY\u0016\fg.\u0001\u000fd_>\u0014H-\u001b8bi>\u0014H*Y4SKB|'\u000f^%oi\u0016\u0014h/\u00197\u0016\u0003]\fqB]3dK&4X-\u00118e%\u0016\u0004H.\u001f\u000b\u0005\u0003/\tI\u0003E\u0004'\u00033\ti\"a\t\n\u0007\u0005mqEA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o!\r1\u0013qD\u0005\u0004\u0003C9#aA!osB\u0019a%!\n\n\u0007\u0005\u001drE\u0001\u0003V]&$\bbBA\u0016%\u0001\u0007\u0011QF\u0001\bG>tG/\u001a=u!\ra\u0013qF\u0005\u0004\u0003ci#A\u0004*qG\u000e\u000bG\u000e\\\"p]R,\u0007\u0010^\u0001\u0012M&tG\rT1hO&twm\u0015;pe\u0016\u001cHCCA\u001c\u0003\u001f\n\u0019&a\u0016\u0002\\A)\u0011\u0011HA%+:!\u00111HA#\u001d\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!G\u00051AH]8pizJ\u0011\u0001K\u0005\u0004\u0003\u000f:\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\niEA\u0002TKFT1!a\u0012(\u0011\u0019\t\tf\u0005a\u0001_\u0006Q\u0011/^3ssJ+h.\u00133\t\r\u0005U3\u00031\u0001x\u0003A\u0011XMZ3sK:\u001cWMV3sg&|g\u000e\u0003\u0004\u0002ZM\u0001\ra^\u0001\u0013e\u00164WM]3oG\u0016$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002^M\u0001\r!!\u0003\u0002)%\u001cH+\u001a:nS:\fG/\u001b8h)JLwmZ3s\u0001")
public class StateStoreCoordinator
implements ThreadSafeRpcEndpoint,
Logging {
    private final RpcEnv rpcEnv;
    private final SQLConf sqlConf;
    private final HashMap<StateStoreProviderId, ExecutorCacheTaskLocation> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances;
    private final HashMap<StateStoreProviderId, SnapshotUploadEvent> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot;
    private final SnapshotUploadEvent org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent;
    private final HashMap<Tuple2<UUID, Object>, BatchCommitTracker> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers;
    private final HashMap<UUID, Object> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final RpcEndpointRef self() {
        return RpcEndpoint.self$((RpcEndpoint)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return RpcEndpoint.receive$((RpcEndpoint)this);
    }

    public void onError(Throwable cause) {
        RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
    }

    public void onConnected(RpcAddress remoteAddress) {
        RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
    }

    public void onDisconnected(RpcAddress remoteAddress) {
        RpcEndpoint.onDisconnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
    }

    public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
        RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
    }

    public void onStart() {
        RpcEndpoint.onStart$((RpcEndpoint)this);
    }

    public void onStop() {
        RpcEndpoint.onStop$((RpcEndpoint)this);
    }

    public final void stop() {
        RpcEndpoint.stop$((RpcEndpoint)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public SQLConf sqlConf() {
        return this.sqlConf;
    }

    public HashMap<StateStoreProviderId, ExecutorCacheTaskLocation> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances;
    }

    public HashMap<StateStoreProviderId, SnapshotUploadEvent> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot;
    }

    public SnapshotUploadEvent org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent;
    }

    public HashMap<Tuple2<UUID, Object>, BatchCommitTracker> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers;
    }

    public HashMap<UUID, Object> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs;
    }

    public boolean org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag() {
        return this.sqlConf().stateStoreCoordinatorReportSnapshotUploadLag();
    }

    public long org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$coordinatorLagReportInterval() {
        return this.sqlConf().stateStoreCoordinatorSnapshotLagReportInterval();
    }

    public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
        return new Serializable(this, context){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StateStoreCoordinator $outer;
            private final RpcCallContext context$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ReportActiveInstance) {
                    ReportActiveInstance reportActiveInstance = (ReportActiveInstance)A1;
                    StateStoreProviderId id = reportActiveInstance.storeId();
                    String host = reportActiveInstance.host();
                    String executorId = reportActiveInstance.executorId();
                    Seq<StateStoreProviderId> providerIdsToCheck = reportActiveInstance.providerIdsToCheck();
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Reported state store " + id + " is active at " + executorId);
                    ExecutorCacheTaskLocation taskLocation = new ExecutorCacheTaskLocation(host, executorId);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().put((Object)id, (Object)taskLocation);
                    Seq providerIdsToUnload = (Seq)providerIdsToCheck.filter((Function1 & Serializable)providerId -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$2(this, taskLocation, providerId)));
                    this.context$1.reply((Object)providerIdsToUnload);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof VerifyIfInstanceActive) {
                    boolean bl;
                    VerifyIfInstanceActive verifyIfInstanceActive = (VerifyIfInstanceActive)A1;
                    StateStoreProviderId id = verifyIfInstanceActive.storeId();
                    String execId = verifyIfInstanceActive.executorId();
                    Option option = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)id);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ExecutorCacheTaskLocation location = (ExecutorCacheTaskLocation)some.value();
                        String string = location.executorId();
                        String string2 = execId;
                        bl = !(string != null ? !string.equals(string2) : string2 != null);
                    } else if (None$.MODULE$.equals(option)) {
                        bl = false;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boolean response = bl;
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Verified that state store " + id + " is active: " + response);
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)response));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLocation) {
                    GetLocation getLocation = (GetLocation)A1;
                    StateStoreProviderId id = getLocation.storeId();
                    Option executorId = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)id).map((Function1 & Serializable)x$2 -> x$2.toString());
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got location of the state store " + id + ": " + executorId);
                    this.context$1.reply((Object)executorId);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof DeactivateInstances) {
                    DeactivateInstances deactivateInstances = (DeactivateInstances)A1;
                    UUID runId = deactivateInstances.runId();
                    Seq storeIdsToRemove = ((IterableOnceOps)this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().keys().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$8(runId, x$3)))).toSeq();
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().$minus$minus$eq((IterableOnce)storeIdsToRemove);
                    Iterable runIdsToRemove = (Iterable)this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().keys().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$9(runId, x$4)));
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().$minus$minus$eq((IterableOnce)runIdsToRemove);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().$minus$minus$eq((IterableOnce)storeIdsToRemove);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().$minus$eq((Object)runId);
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deactivating instances related to checkpoint location " + runId + ": " + storeIdsToRemove.mkString(", "));
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ReportSnapshotUploaded) {
                    ReportSnapshotUploaded reportSnapshotUploaded = (ReportSnapshotUploaded)A1;
                    StateStoreProviderId providerId2 = reportSnapshotUploaded.providerId();
                    long version = reportSnapshotUploaded.version();
                    long timestamp = reportSnapshotUploaded.timestamp();
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot version " + version + " was uploaded for state store " + providerId2);
                    Object object = !this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId2).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$12(version, x$5))) ? this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().put((Object)providerId2, (Object)new SnapshotUploadEvent(version, timestamp)) : BoxedUnit.UNIT;
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof LogLaggingStateStores) {
                    Seq<StateStoreProviderId> laggingStores;
                    LogLaggingStateStores logLaggingStateStores = (LogLaggingStateStores)A1;
                    UUID queryRunId = logLaggingStateStores.queryRunId();
                    long latestVersion = logLaggingStateStores.latestVersion();
                    boolean isTerminatingTrigger = logLaggingStateStores.isTerminatingTrigger();
                    long currentTimestamp = System.currentTimeMillis();
                    if (this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag() && (laggingStores = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(queryRunId, latestVersion, currentTimestamp, isTerminatingTrigger)).nonEmpty()) {
                        this.$outer.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"StateStoreCoordinator Snapshot Lag Report for "}))).log((Seq)Nil$.MODULE$).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"queryRunId=", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.QUERY_RUN_ID, queryRunId)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Number of state stores falling behind: "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.NUM_LAGGING_STORES, BoxesRunTime.boxToInteger((int)laggingStores.size()))})))));
                        long timeSinceLastReport = currentTimestamp - BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().getOrElse((Object)queryRunId, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                        if (timeSinceLastReport > this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$coordinatorLagReportInterval()) {
                            this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().put((Object)queryRunId, (Object)BoxesRunTime.boxToLong((long)currentTimestamp));
                            ((IterableOnceOps)((IterableOps)laggingStores.sortBy((Function1 & Serializable)x$6 -> (SnapshotUploadEvent)$this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().getOrElse(x$6, (Function0 & Serializable)() -> $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent()), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).take(this.$outer.sqlConf().stateStoreCoordinatorMaxLaggingStoresToReport())).foreach((Function1 & Serializable)providerId -> {
                                $anonfun$receiveAndReply$1.$anonfun$applyOrElse$17(this, queryRunId, latestVersion, currentTimestamp, providerId);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof StartStateStoreCommitTrackingForBatch) {
                    StartStateStoreCommitTrackingForBatch startStateStoreCommitTrackingForBatch = (StartStateStoreCommitTrackingForBatch)A1;
                    UUID runId = startStateStoreCommitTrackingForBatch.runId();
                    long batchId = startStateStoreCommitTrackingForBatch.batchId();
                    scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> expectedStores = startStateStoreCommitTrackingForBatch.expectedStores();
                    Tuple2 key = new Tuple2((Object)runId, (Object)BoxesRunTime.boxToLong((long)batchId));
                    if (this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().contains((Object)key)) {
                        this.context$1.sendFailure((Throwable)new IllegalStateException("Batch commit tracker already exists for runId=" + runId + ", batchId=" + batchId));
                        return (B1)BoxedUnit.UNIT;
                    }
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().put((Object)key, (Object)new BatchCommitTracker(runId, batchId, expectedStores));
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "Started tracking commits for batch " + batchId + " with " + ((IterableOnceOps)expectedStores.values().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$20(x$7)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$) + " expected stores");
                    this.context$1.reply((Object)BoxedUnit.UNIT);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ReportStateStoreCommit) {
                    ReportStateStoreCommit reportStateStoreCommit = (ReportStateStoreCommit)A1;
                    StateStoreProviderId storeId = reportStateStoreCommit.storeId();
                    long version = reportStateStoreCommit.version();
                    String storeName = reportStateStoreCommit.storeName();
                    long batchId = version - 1L;
                    Tuple2 key = new Tuple2((Object)storeId.queryRunId(), (Object)BoxesRunTime.boxToLong((long)batchId));
                    Option option = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().get((Object)key);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BatchCommitTracker tracker = (BatchCommitTracker)some.value();
                        tracker.recordCommit(storeId, storeName);
                        this.context$1.reply((Object)BoxedUnit.UNIT);
                    } else if (None$.MODULE$.equals(option)) {
                        this.context$1.reply((Object)BoxedUnit.UNIT);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ValidateStateStoreCommitForBatch) {
                    ValidateStateStoreCommitForBatch validateStateStoreCommitForBatch = (ValidateStateStoreCommitForBatch)A1;
                    UUID runId = validateStateStoreCommitForBatch.runId();
                    long batchId = validateStateStoreCommitForBatch.batchId();
                    Tuple2 key = new Tuple2((Object)runId, (Object)BoxesRunTime.boxToLong((long)batchId));
                    Option option = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().get((Object)key);
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        BatchCommitTracker tracker = (BatchCommitTracker)some.value();
                        try {
                            tracker.validateAllCommitted();
                            this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().remove((Object)key);
                            this.context$1.reply((Object)BoxedUnit.UNIT);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (StateStoreCommitValidationFailed e) {
                            this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().remove((Object)key);
                            this.context$1.sendFailure((Throwable)((Object)e));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else if (None$.MODULE$.equals(option)) {
                        this.context$1.sendFailure((Throwable)new IllegalStateException("No commit tracker found for runId=" + runId + ", batchId=" + batchId));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLatestSnapshotVersionForTesting) {
                    GetLatestSnapshotVersionForTesting getLatestSnapshotVersionForTesting = (GetLatestSnapshotVersionForTesting)A1;
                    StateStoreProviderId providerId3 = getLatestSnapshotVersionForTesting.providerId();
                    Option version = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId3).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$21(x$8)));
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got latest snapshot version of the state store " + providerId3 + ": " + version);
                    this.context$1.reply((Object)version);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLaggingStoresForTesting) {
                    GetLaggingStoresForTesting getLaggingStoresForTesting = (GetLaggingStoresForTesting)A1;
                    UUID queryRunId = getLaggingStoresForTesting.queryRunId();
                    long latestVersion = getLaggingStoresForTesting.latestVersion();
                    boolean isTerminatingTrigger = getLaggingStoresForTesting.isTerminatingTrigger();
                    long currentTimestamp = System.currentTimeMillis();
                    if (this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag()) {
                        Seq<StateStoreProviderId> laggingStores = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(queryRunId, latestVersion, currentTimestamp, isTerminatingTrigger);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got lagging state stores: " + laggingStores.mkString(", "));
                        this.context$1.reply(laggingStores);
                        return (B1)BoxedUnit.UNIT;
                    }
                    this.context$1.reply((Object)package$.MODULE$.Seq().empty());
                    return (B1)BoxedUnit.UNIT;
                }
                if (StopCoordinator$.MODULE$.equals(A1)) {
                    this.$outer.stop();
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "StateStoreCoordinator stopped");
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ReportActiveInstance) {
                    return true;
                }
                if (object instanceof VerifyIfInstanceActive) {
                    return true;
                }
                if (object instanceof GetLocation) {
                    return true;
                }
                if (object instanceof DeactivateInstances) {
                    return true;
                }
                if (object instanceof ReportSnapshotUploaded) {
                    return true;
                }
                if (object instanceof LogLaggingStateStores) {
                    return true;
                }
                if (object instanceof StartStateStoreCommitTrackingForBatch) {
                    return true;
                }
                if (object instanceof ReportStateStoreCommit) {
                    return true;
                }
                if (object instanceof ValidateStateStoreCommitForBatch) {
                    return true;
                }
                if (object instanceof GetLatestSnapshotVersionForTesting) {
                    return true;
                }
                if (object instanceof GetLaggingStoresForTesting) {
                    return true;
                }
                return StopCoordinator$.MODULE$.equals(object);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$3(ExecutorCacheTaskLocation taskLocation$1, ExecutorCacheTaskLocation x$1) {
                ExecutorCacheTaskLocation executorCacheTaskLocation = x$1;
                ExecutorCacheTaskLocation executorCacheTaskLocation2 = taskLocation$1;
                return executorCacheTaskLocation == null ? executorCacheTaskLocation2 != null : !executorCacheTaskLocation.equals(executorCacheTaskLocation2);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2($anonfun$receiveAndReply$1 $this, ExecutorCacheTaskLocation taskLocation$1, StateStoreProviderId providerId) {
                Option providerLoc = $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)providerId);
                return BoxesRunTime.unboxToBoolean((Object)providerLoc.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$3(taskLocation$1, x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$8(UUID runId$1, StateStoreProviderId x$3) {
                UUID uUID = x$3.queryRunId();
                UUID uUID2 = runId$1;
                return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$9(UUID runId$1, Tuple2 x$4) {
                Object object = x$4._1();
                UUID uUID = runId$1;
                return !(object != null ? !object.equals(uUID) : uUID != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$12(long version$1, SnapshotUploadEvent x$5) {
                return x$5.version() >= version$1;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$17($anonfun$receiveAndReply$1 $this, UUID queryRunId$1, long latestVersion$1, long currentTimestamp$1, StateStoreProviderId providerId) {
                MessageWithContext messageWithContext;
                MessageWithContext baseLogMessage = $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"StateStoreCoordinator Snapshot Lag Detected for "}))).log((Seq)Nil$.MODULE$).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"queryRunId=", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.QUERY_RUN_ID, queryRunId$1)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Store ID: ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.STATE_STORE_ID, providerId.storeId())}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(Latest batch ID: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)latestVersion$1))})));
                Option option = $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SnapshotUploadEvent snapshotEvent = (SnapshotUploadEvent)some.value();
                    long versionDelta = latestVersion$1 - snapshotEvent.version();
                    long timeDelta = currentTimestamp$1 - snapshotEvent.timestamp();
                    messageWithContext = baseLogMessage.$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{", "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"latest snapshot: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.SNAPSHOT_EVENT, snapshotEvent)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"version delta: "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.SNAPSHOT_EVENT_VERSION_DELTA, BoxesRunTime.boxToLong((long)versionDelta))}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time delta: ", "ms)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.SNAPSHOT_EVENT_TIME_DELTA, BoxesRunTime.boxToLong((long)timeDelta))})));
                } else if (None$.MODULE$.equals(option)) {
                    messageWithContext = baseLogMessage.$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{", latest snapshot: no upload for query run)"}))).log((Seq)Nil$.MODULE$));
                } else {
                    throw new MatchError((Object)option);
                }
                MessageWithContext logMessage = messageWithContext;
                $this.$outer.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMessage));
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$20(scala.collection.immutable.Map x$7) {
                return BoxesRunTime.unboxToInt((Object)x$7.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }

            public static final /* synthetic */ long $anonfun$applyOrElse$21(SnapshotUploadEvent x$8) {
                return x$8.version();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.context$1 = context$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId java.lang.String ), $anonfun$applyOrElse$10(java.util.UUID scala.collection.immutable.Seq ), $anonfun$applyOrElse$11(long org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$12$adapted(long org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent ), $anonfun$applyOrElse$13(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 java.util.UUID scala.collection.immutable.Seq ), $anonfun$applyOrElse$14(), $anonfun$applyOrElse$15(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$16(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 ), $anonfun$applyOrElse$17$adapted(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 java.util.UUID long long org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$18(org.apache.spark.internal.MessageWithContext ), $anonfun$applyOrElse$19(long scala.collection.immutable.Map ), $anonfun$applyOrElse$2$adapted(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 org.apache.spark.scheduler.ExecutorCacheTaskLocation org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$20$adapted(scala.collection.immutable.Map ), $anonfun$applyOrElse$21$adapted(org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent ), $anonfun$applyOrElse$22(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId scala.Option ), $anonfun$applyOrElse$23(scala.collection.immutable.Seq ), $anonfun$applyOrElse$24(), $anonfun$applyOrElse$3$adapted(org.apache.spark.scheduler.ExecutorCacheTaskLocation org.apache.spark.scheduler.ExecutorCacheTaskLocation ), $anonfun$applyOrElse$4(), $anonfun$applyOrElse$5(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId boolean ), $anonfun$applyOrElse$6(org.apache.spark.scheduler.ExecutorCacheTaskLocation ), $anonfun$applyOrElse$7(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId scala.Option ), $anonfun$applyOrElse$8$adapted(java.util.UUID org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$9$adapted(java.util.UUID scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public Seq<StateStoreProviderId> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(UUID queryRunId, long referenceVersion, long referenceTimestamp, boolean isTerminatingTrigger) {
        long snapshotVersionDeltaMultiplier = this.sqlConf().stateStoreCoordinatorMultiplierForMinVersionDiffToLog();
        long maintenanceIntervalMultiplier = this.sqlConf().stateStoreCoordinatorMultiplierForMinTimeDiffToLog();
        int minDeltasForSnapshot = this.sqlConf().stateStoreMinDeltasForSnapshot();
        long maintenanceInterval = this.sqlConf().streamingMaintenanceInterval();
        long minVersionDeltaForLogging = snapshotVersionDeltaMultiplier * (long)minDeltasForSnapshot;
        long minTimeDeltaForLogging = maintenanceIntervalMultiplier * maintenanceInterval;
        return ((IterableOnceOps)((IterableOps)this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().view().keys().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StateStoreCoordinator.$anonfun$findLaggingStores$1(queryRunId, x$9)))).filter((Function1 & Serializable)storeProviderId -> BoxesRunTime.boxToBoolean((boolean)StateStoreCoordinator.$anonfun$findLaggingStores$2(this, referenceVersion, minVersionDeltaForLogging, referenceTimestamp, minTimeDeltaForLogging, isTerminatingTrigger, storeProviderId)))).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$findLaggingStores$1(UUID queryRunId$2, StateStoreProviderId x$9) {
        UUID uUID = x$9.queryRunId();
        UUID uUID2 = queryRunId$2;
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findLaggingStores$2(StateStoreCoordinator $this, long referenceVersion$1, long minVersionDeltaForLogging$1, long referenceTimestamp$1, long minTimeDeltaForLogging$1, boolean isTerminatingTrigger$1, StateStoreProviderId storeProviderId) {
        SnapshotUploadEvent latestSnapshot = (SnapshotUploadEvent)$this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().getOrElse((Object)storeProviderId, (Function0 & Serializable)() -> $this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent());
        boolean isBehindOnVersions = referenceVersion$1 - latestSnapshot.version() > minVersionDeltaForLogging$1;
        boolean isBehindOnTime = referenceTimestamp$1 - latestSnapshot.timestamp() > minTimeDeltaForLogging$1;
        return isBehindOnVersions && (isTerminatingTrigger$1 || isBehindOnTime);
    }

    public StateStoreCoordinator(RpcEnv rpcEnv, SQLConf sqlConf) {
        this.rpcEnv = rpcEnv;
        this.sqlConf = sqlConf;
        RpcEndpoint.$init$((RpcEndpoint)this);
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent = new SnapshotUploadEvent(0L, 0L);
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs = new HashMap();
    }
}

