/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mx!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005\"\u0002#\u0002\t\u0003)\u0005B\u0002#\u0002\t\u0003\t\u0019\u000e\u0003\u0005E\u0003\u0005\u0005I\u0011QAl\u0011%\ti.AI\u0001\n\u0003\t)\u0006C\u0005\u0002`\u0006\t\t\u0011\"!\u0002b\"I\u0011q^\u0001\u0012\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003c\f\u0011\u0011!C\u0005\u0003g4AAM\u0012A\u000f\"AAL\u0003BK\u0002\u0013\u0005Q\f\u0003\u0005_\u0015\tE\t\u0015!\u0003I\u0011!y&B!f\u0001\n\u0003\u0001\u0007\u0002\u00033\u000b\u0005#\u0005\u000b\u0011B1\t\u000b\tSA\u0011A3\t\u000b\tSA\u0011\u00015\t\u000b\tSA\u0011A6\t\u000b5TA\u0011\t8\t\u000b]TA\u0011\u000b8\t\u000baTA\u0011I=\t\raTA\u0011IA\u0005\u0011\u001d\t\tB\u0003C!\u0003'Aq!!\n\u000b\t#\n9\u0003C\u0005\u00024)\t\t\u0011\"\u0001\u00026!I\u00111\b\u0006\u0012\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003'R\u0011\u0013!C\u0001\u0003+B\u0011\"!\u0017\u000b\u0003\u0003%\t%a\u0017\t\u0013\u0005\u001d$\"!A\u0005\u0002\u0005%\u0004\"CA9\u0015\u0005\u0005I\u0011AA:\u0011%\tyHCA\u0001\n\u0003\n\t\tC\u0005\u0002\u0010*\t\t\u0011\"\u0001\u0002\u0012\"I\u00111\u0014\u0006\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003CS\u0011\u0011!C!\u0003G\u000bab\u0015;sS:<GK]5n\u0019\u00164GO\u0003\u0002%K\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1s%\u0001\u0005dCR\fG._:u\u0015\tA\u0013&A\u0002tc2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001!\t\t\u0014!D\u0001$\u00059\u0019FO]5oOR\u0013\u0018.\u001c'fMR\u001c2!\u0001\u001b;!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fMB\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0003S>T\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012\u0001M\u0001\u0006CB\u0004H.\u001f\u000b\u0006\r\u00065\u0017\u0011\u001b\t\u0003c)\u0019RA\u0003%L\u001dF\u0003\"!M%\n\u0005)\u001b#AC#yaJ,7o]5p]B\u0011\u0011\u0007T\u0005\u0003\u001b\u000e\u0012Qc\u0015;sS:<'\u0007\u0016:j[\u0016C\bO]3tg&|g\u000e\u0005\u00026\u001f&\u0011\u0001K\u000e\u0002\b!J|G-^2u!\t\u0011&L\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011akL\u0001\u0007yI|w\u000e\u001e \n\u0003]J!!\u0017\u001c\u0002\u000fA\f7m[1hK&\u0011\u0011i\u0017\u0006\u00033Z\naa\u001d:d'R\u0014X#\u0001%\u0002\u000fM\u00148m\u0015;sA\u00059AO]5n'R\u0014X#A1\u0011\u0007U\u0012\u0007*\u0003\u0002dm\t1q\n\u001d;j_:\f\u0001\u0002\u001e:j[N#(\u000f\t\u000b\u0004\r\u001a<\u0007\"\u0002/\u0010\u0001\u0004A\u0005bB0\u0010!\u0003\u0005\r!\u0019\u000b\u0004\r&T\u0007\"B0\u0011\u0001\u0004A\u0005\"\u0002/\u0011\u0001\u0004AEC\u0001$m\u0011\u0015a\u0016\u00031\u0001I\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002_B\u0011\u0001\u000f\u001e\b\u0003cJ\u0004\"\u0001\u0016\u001c\n\u0005M4\u0014A\u0002)sK\u0012,g-\u0003\u0002vm\n11\u000b\u001e:j]\u001eT!a\u001d\u001c\u0002\u0013\u0011L'/Z2uS>t\u0017A\u00023p\u000bZ\fG\u000eF\u0002{\u0003\u000b\u00012a_A\u0001\u001b\u0005a(BA?\u007f\u0003\u0015!\u0018\u0010]3t\u0015\ty\u0018&\u0001\u0004v]N\fg-Z\u0005\u0004\u0003\u0007a(AC+U\rb\u001aFO]5oO\"1\u0011q\u0001\u000bA\u0002i\f\u0011b\u001d:d'R\u0014\u0018N\\4\u0015\u000bi\fY!!\u0004\t\r\u0005\u001dQ\u00031\u0001{\u0011\u0019\ty!\u0006a\u0001u\u0006QAO]5n'R\u0014\u0018N\\4\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002\u0016A)!+a\u0006\u0002\u001c%\u0019\u0011\u0011D.\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u001e\u0005\u0005RBAA\u0010\u0015\tix%\u0003\u0003\u0002$\u0005}!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002G\u0003SAq!a\u000b\u0018\u0001\u0004\ti#A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007\u0003\u0002*\u00020!K1!!\r\\\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010F\u0003G\u0003o\tI\u0004C\u0004]1A\u0005\t\u0019\u0001%\t\u000f}C\u0002\u0013!a\u0001C\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA U\rA\u0015\u0011I\u0016\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\n\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA,U\r\t\u0017\u0011I\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rd(\u0001\u0003mC:<\u0017bA;\u0002b\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u000e\t\u0004k\u00055\u0014bAA8m\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QOA>!\r)\u0014qO\u0005\u0004\u0003s2$aA!os\"I\u0011QP\u000f\u0002\u0002\u0003\u0007\u00111N\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0005CBAC\u0003\u0017\u000b)(\u0004\u0002\u0002\b*\u0019\u0011\u0011\u0012\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u000e\u0006\u001d%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a%\u0002\u001aB\u0019Q'!&\n\u0007\u0005]eGA\u0004C_>dW-\u00198\t\u0013\u0005ut$!AA\u0002\u0005U\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0018\u0002 \"I\u0011Q\u0010\u0011\u0002\u0002\u0003\u0007\u00111N\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u0015Q\u0015\u0005\n\u0003{\n\u0013\u0011!a\u0001\u0003kBsCCAU\u0003_\u000b\t,!.\u00028\u0006m\u0016QXAa\u0003\u0007\f9-!3\u0011\u0007E\nY+C\u0002\u0002.\u000e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00024\u00061%\u0002\t\u0011!A}3UKT\"`QM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!gB\f7-\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\tI,AA\u000f\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"(/[7TiJ\u0004S\u0006\t;iK\u0002\"(/[7!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\b\u0005^8!iJLW\u000e\f\u0011uQ\u0016\u0004C-\u001a4bk2$\bE^1mk\u0016\u0004\u0013n\u001d\u0011bAMLgn\u001a7fAM\u0004\u0018mY3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u007f\u000b1J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0011!A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'\u000bA\u0001\nQa]5oG\u0016\f#!!2\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005-\u0017\u0001D:ue&twm\u00184v]\u000e\u001c\bBBAh\u0007\u0001\u0007\u0001*A\u0002tiJDQaX\u0002A\u0002!#2ARAk\u0011\u0019\ty\r\u0002a\u0001\u0011R)a)!7\u0002\\\")A,\u0002a\u0001\u0011\"9q,\u0002I\u0001\u0002\u0004\t\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u00111]Av!\u0011)$-!:\u0011\u000bU\n9\u000fS1\n\u0007\u0005%hG\u0001\u0004UkBdWM\r\u0005\t\u0003[<\u0011\u0011!a\u0001\r\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t)\u0010\u0005\u0003\u0002`\u0005]\u0018\u0002BA}\u0003C\u0012aa\u00142kK\u000e$\b")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private int collationId;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft x$0) {
        return StringTrimLeft$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return String2TrimExpression.contextIndependentFoldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int collationId$lzycompute() {
        StringTrimLeft stringTrimLeft = this;
        synchronized (stringTrimLeft) {
            if (!this.bitmap$0) {
                this.collationId = String2TrimExpression.collationId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    @Override
    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public String direction() {
        return "LEADING";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return CollationSupport.StringTrimLeft.exec((UTF8String)srcString);
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return CollationSupport.StringTrimLeft.exec((UTF8String)srcString, (UTF8String)trimString, (int)this.collationId());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)Nil$.MODULE$));
    }

    @Override
    public StringTrimLeft withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcStr();
            }
            case 1: {
                return this.trimStr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcStr";
            }
            case 1: {
                return "trimStr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

