/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u3A\u0001C\u0005\u00011!)\u0011\u0006\u0001C\u0001U!)A\u0006\u0001C![!)\u0001\u0007\u0001C\u0005c!)A\t\u0001C\u0005\u000b\")A\n\u0001C\u0005\u001b\")\u0001\u000b\u0001C\u0005#\")A\u000b\u0001C\u0005+\n9B*[7ji\u0016C\bO]3tg&|gNU3t_24XM\u001d\u0006\u0003\u0015-\t\u0001B]3t_24XM\u001d\u0006\u0003\u00195\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u001d=\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0003!C\r\u001aS\"A\u0005\n\u0005\tJ!\u0001\u0005+sK\u0016tu\u000eZ3SKN|GN^3s!\t!s%D\u0001&\u0015\t1S\"A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u0015&\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0002\"\u0001\t\u0001\u0002\u000fI,7o\u001c7wKR\u00111E\f\u0005\u0006_\t\u0001\raI\u0001\u001ak:\u0014Xm]8mm\u0016$G*[7ji\u0016C\bO]3tg&|g.A\fwC2LG-\u0019;f\u0019&l\u0017\u000e^#yaJ,7o]5p]R\u0019!'N\u001c\u0011\u0005i\u0019\u0014B\u0001\u001b\u001c\u0005\u0011)f.\u001b;\t\u000bY\u001a\u0001\u0019A\u0012\u0002\u0015\u0015D\bO]3tg&|g\u000eC\u00039\u0007\u0001\u0007\u0011(\u0001\bfqB\u0014Xm]:j_:t\u0015-\\3\u0011\u0005i\neBA\u001e@!\ta4$D\u0001>\u0015\tqt#\u0001\u0004=e>|GOP\u0005\u0003\u0001n\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001iG\u0001,i\"\u0014xn^%om\u0006d\u0017\u000e\u001a'j[&$H*[6f\u000bb\u0004(/Z:tS>t\u0017j]+oM>dG-\u00192mKR\u0019a)S&\u0011\u0005i9\u0015B\u0001%\u001c\u0005\u001dqu\u000e\u001e5j]\u001eDQA\u0013\u0003A\u0002e\nAA\\1nK\")a\u0007\u0002a\u0001G\u00059C\u000f\u001b:po&sg/\u00197jI2KW.\u001b;MS.,W\t\u001f9sKN\u001c\u0018n\u001c8ECR\fG+\u001f9f)\r1ej\u0014\u0005\u0006\u0015\u0016\u0001\r!\u000f\u0005\u0006m\u0015\u0001\raI\u0001&i\"\u0014xn^%om\u0006d\u0017\u000e\u001a'j[&$H*[6f\u000bb\u0004(/Z:tS>t\u0017j\u001d(vY2$2A\u0012*T\u0011\u0015Qe\u00011\u0001:\u0011\u00151d\u00011\u0001$\u0003%\"\bN]8x\u0013:4\u0018\r\\5e\u0019&l\u0017\u000e\u001e'jW\u0016,\u0005\u0010\u001d:fgNLwN\\%t\u001d\u0016<\u0017\r^5wKR!aIV,Y\u0011\u0015Qu\u00011\u0001:\u0011\u00151t\u00011\u0001$\u0011\u0015Iv\u00011\u0001[\u0003\u00151\u0018\r\\;f!\tQ2,\u0003\u0002]7\t\u0019\u0011J\u001c;")
public class LimitExpressionResolver
implements TreeNodeResolver<Expression, Expression> {
    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public Expression resolve(Expression unresolvedLimitExpression) {
        this.validateLimitExpression(unresolvedLimitExpression, "limit");
        return unresolvedLimitExpression;
    }

    private void validateLimitExpression(Expression expression, String expressionName) {
        int n;
        if (!expression.foldable()) {
            throw this.throwInvalidLimitLikeExpressionIsUnfoldable(expressionName, expression);
        }
        DataType dataType = expression.dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            throw this.throwInvalidLimitLikeExpressionDataType(expressionName, expression);
        }
        Object object = expression.eval(expression.eval$default$1());
        if (object == null) {
            throw this.throwInvalidLimitLikeExpressionIsNull(expressionName, expression);
        }
        if (object instanceof Integer && (n = BoxesRunTime.unboxToInt((Object)object)) < 0) {
            throw this.throwInvalidLimitLikeExpressionIsNegative(expressionName, expression, n);
        }
    }

    private Nothing$ throwInvalidLimitLikeExpressionIsUnfoldable(String name, Expression expression) {
        throw new AnalysisException("INVALID_LIMIT_LIKE_EXPRESSION.IS_UNFOLDABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expression))})), expression.origin());
    }

    private Nothing$ throwInvalidLimitLikeExpressionDataType(String name, Expression expression) {
        throw new AnalysisException("INVALID_LIMIT_LIKE_EXPRESSION.DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expression)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)expression.dataType()))})), expression.origin());
    }

    private Nothing$ throwInvalidLimitLikeExpressionIsNull(String name, Expression expression) {
        throw new AnalysisException("INVALID_LIMIT_LIKE_EXPRESSION.IS_NULL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expression))})), expression.origin());
    }

    private Nothing$ throwInvalidLimitLikeExpressionIsNegative(String name, Expression expression, int value) {
        throw new AnalysisException("INVALID_LIMIT_LIKE_EXPRESSION.IS_NEGATIVE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expression)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)value), (DataType)IntegerType$.MODULE$))})), expression.origin());
    }

    public LimitExpressionResolver() {
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

