/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.sling.ide.eclipse.core.facet.FacetHelper;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectHelper {
    private static final String SLING_FEATURE_FACET_ID = "sling.feature";
    private static final String[] CONTENT_PACKAGE_STRUCTURE_BASE = new String[]{"/", "/content", "/src/main/content"};

    public static boolean isPotentialBundleProject(IProject project) {
        try {
            return !ProjectHelper.isBundleProject(project) && !ProjectHelper.isContentProject(project) && project.getDescription().hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            Activator.getDefault().getPluginLogger().warn("Failed getting project description", (Throwable)e);
            return false;
        }
    }

    public static boolean isPotentialContentProject(IProject project) {
        return !ProjectHelper.isContentProject(project) && !ProjectHelper.isBundleProject(project) && ProjectHelper.getInferredContentProjectContentRoot(project) != null;
    }

    public static IContainer getInferredContentProjectContentRoot(IProject project) {
        String[] stringArray = CONTENT_PACKAGE_STRUCTURE_BASE;
        int n = CONTENT_PACKAGE_STRUCTURE_BASE.length;
        int n2 = 0;
        while (n2 < n) {
            String base = stringArray[n2];
            Object container = "/".equals(base) ? project : project.getFolder(base);
            if (container.exists() && ProjectHelper.hasContentPackageStructure((IContainer)container)) {
                return container;
            }
            ++n2;
        }
        return null;
    }

    public static String validateContentPackageStructure(IContainer base) {
        IFile filterXml = base.getFile(Path.fromPortableString((String)"META-INF/vault/filter.xml"));
        IFolder jcrRoot = base.getFolder(Path.fromPortableString((String)"jcr_root"));
        if (!filterXml.exists()) {
            return String.format("Could not find FileVault filter at '%s'", filterXml.getRawLocationURI());
        }
        if (!jcrRoot.exists()) {
            return String.format("Could not find JCR root at '%s'", jcrRoot.getRawLocationURI());
        }
        return null;
    }

    public static boolean hasContentPackageStructure(IContainer jcrRootDir) {
        return ProjectHelper.validateContentPackageStructure(jcrRootDir) == null;
    }

    public static String getMavenProperty(IProject project, String name) {
        IFile file;
        DocumentBuilder docBuilder;
        block8: {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            file = project.getFile("pom.xml");
            if (file != null && file.exists()) break block8;
            return null;
        }
        try {
            Document document = docBuilder.parse(file.getContents());
            Element docElement = document.getDocumentElement();
            NodeList children = docElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node aChild = children.item(i);
                if (aChild.getNodeName().equals(name)) {
                    Element e = (Element)aChild;
                    String text = e.getTextContent();
                    return text;
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().getPluginLogger().warn("Failed getting maven property for " + project.getName(), (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            Activator.getDefault().getPluginLogger().warn("Failed getting maven property for " + project.getName(), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            Activator.getDefault().getPluginLogger().warn("Failed getting maven property for " + project.getName(), (Throwable)e);
            return null;
        }
        catch (CoreException e) {
            Activator.getDefault().getPluginLogger().warn("Failed getting maven property for " + project.getName(), (Throwable)e);
            return null;
        }
        return null;
    }

    public static boolean isBundleProject(IProject project) {
        return FacetHelper.containsFacet(project, "sling.bundle");
    }

    public static boolean isContentProject(IProject project) {
        return FacetHelper.containsFacet(project, "sling.content");
    }

    public static boolean isLaunchpadProject(IProject project) {
        return FacetHelper.containsFacet(project, "sling.launchpad");
    }

    public static boolean isFeatureProject(IProject project) {
        return FacetHelper.containsFacet(project, SLING_FEATURE_FACET_ID);
    }

    public static IJavaProject asJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    static IJavaProject[] getAllJavaProjects() {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            return model.getJavaProjects();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }
}

