/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.osgi;

import org.ops4j.peaberry.ServiceException;
import org.ops4j.peaberry.cache.AbstractServiceListener;
import org.ops4j.peaberry.internal.InvalidSyntaxException;
import org.ops4j.peaberry.osgi.OSGiServiceImport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OSGiServiceListener<T>
extends AbstractServiceListener<T>
implements ServiceListener {
    private final BundleContext bundleContext;
    private final String ldapFilter;

    OSGiServiceListener(BundleContext bundleContext, String ldapFilter) {
        this.bundleContext = bundleContext;
        this.ldapFilter = ldapFilter;
    }

    @Override
    protected synchronized void start() {
        try {
            this.bundleContext.addServiceListener((ServiceListener)this, this.ldapFilter);
            ServiceReference[] refs = this.bundleContext.getServiceReferences(null, this.ldapFilter);
            if (null != refs) {
                for (ServiceReference r : refs) {
                    this.insertService(new OSGiServiceImport(this.bundleContext, r));
                }
            }
        }
        catch (InvalidSyntaxException e) {
            throw new ServiceException(e);
        }
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        OSGiServiceImport service = new OSGiServiceImport(this.bundleContext, event.getServiceReference());
        switch (event.getType()) {
            case 1: {
                this.insertService(service);
                break;
            }
            case 2: {
                this.updateService(service);
                break;
            }
            case 4: {
                this.removeService(service);
                break;
            }
        }
    }
}

