/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.profile;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.commands.CommandService;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.profile.ProfileSnapshotSender;
import org.apache.skywalking.apm.agent.core.profile.ProfileTask;
import org.apache.skywalking.apm.agent.core.profile.ProfileTaskExecutionService;
import org.apache.skywalking.apm.agent.core.profile.TracingThreadSnapshot;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.Status;
import org.apache.skywalking.apm.dependencies.io.grpc.StatusRuntimeException;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.profile.v3.ProfileTaskCommandQuery;
import org.apache.skywalking.apm.network.language.profile.v3.ProfileTaskFinishReport;
import org.apache.skywalking.apm.network.language.profile.v3.ProfileTaskGrpc;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@DefaultImplementor
public class ProfileTaskChannelService
implements BootService,
Runnable,
GRPCChannelListener {
    private static final ILog LOGGER = LogManager.getLogger(ProfileTaskChannelService.class);
    private volatile GRPCChannelStatus status = GRPCChannelStatus.DISCONNECT;
    private volatile ProfileTaskGrpc.ProfileTaskBlockingStub profileTaskBlockingStub;
    private final BlockingQueue<TracingThreadSnapshot> snapshotQueue = new LinkedBlockingQueue<TracingThreadSnapshot>(Config.Profile.SNAPSHOT_TRANSPORT_BUFFER_SIZE);
    private volatile ScheduledFuture<?> sendSnapshotFuture;
    private volatile ScheduledFuture<?> getTaskListFuture;
    private ProfileSnapshotSender sender;

    @Override
    public void run() {
        block5: {
            if (this.status == GRPCChannelStatus.CONNECTED) {
                try {
                    ProfileTaskCommandQuery.Builder builder = ProfileTaskCommandQuery.newBuilder();
                    builder.setService(Config.Agent.SERVICE_NAME).setServiceInstance(Config.Agent.INSTANCE_NAME);
                    builder.setLastCommandTime(ServiceManager.INSTANCE.findService(ProfileTaskExecutionService.class).getLastCommandCreateTime());
                    Commands commands = ((ProfileTaskGrpc.ProfileTaskBlockingStub)this.profileTaskBlockingStub.withDeadlineAfter(Config.Collector.GRPC_UPSTREAM_TIMEOUT, TimeUnit.SECONDS)).getProfileTaskCommands(builder.build());
                    ServiceManager.INSTANCE.findService(CommandService.class).receiveCommand(commands);
                }
                catch (Throwable t) {
                    if (!(t instanceof StatusRuntimeException)) {
                        LOGGER.error(t, "Query profile task from backend fail.", new Object[0]);
                        return;
                    }
                    StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
                    if (statusRuntimeException.getStatus().getCode() != Status.Code.UNIMPLEMENTED) break block5;
                    LOGGER.warn("Backend doesn't support profiling, profiling will be disabled", new Object[0]);
                    if (this.getTaskListFuture != null) {
                        this.getTaskListFuture.cancel(true);
                    }
                    if (this.sendSnapshotFuture == null) break block5;
                    this.sendSnapshotFuture.cancel(true);
                }
            }
        }
    }

    @Override
    public void prepare() {
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this);
    }

    @Override
    public void boot() {
        this.sender = ServiceManager.INSTANCE.findService(ProfileSnapshotSender.class);
        if (Config.Profile.ACTIVE) {
            this.getTaskListFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("ProfileGetTaskService")).scheduleWithFixedDelay(new RunnableWithExceptionProtection(this, t -> LOGGER.error("Query profile task list failure.", t)), 0L, Config.Collector.GET_PROFILE_TASK_INTERVAL, TimeUnit.SECONDS);
            this.sendSnapshotFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("ProfileSendSnapshotService")).scheduleWithFixedDelay(new RunnableWithExceptionProtection(() -> {
                ArrayList<TracingThreadSnapshot> buffer = new ArrayList<TracingThreadSnapshot>(Config.Profile.SNAPSHOT_TRANSPORT_BUFFER_SIZE);
                this.snapshotQueue.drainTo(buffer);
                if (!buffer.isEmpty()) {
                    this.sender.send(buffer);
                }
            }, t -> LOGGER.error("Profile segment snapshot upload failure.", t)), 0L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void shutdown() {
        if (this.getTaskListFuture != null) {
            this.getTaskListFuture.cancel(true);
        }
        if (this.sendSnapshotFuture != null) {
            this.sendSnapshotFuture.cancel(true);
        }
    }

    @Override
    public void statusChanged(GRPCChannelStatus status) {
        if (GRPCChannelStatus.CONNECTED.equals((Object)status)) {
            Channel channel = ServiceManager.INSTANCE.findService(GRPCChannelManager.class).getChannel();
            this.profileTaskBlockingStub = ProfileTaskGrpc.newBlockingStub(channel);
        } else {
            this.profileTaskBlockingStub = null;
        }
        this.status = status;
    }

    public void addProfilingSnapshot(TracingThreadSnapshot snapshot) {
        this.snapshotQueue.offer(snapshot);
    }

    public void notifyProfileTaskFinish(ProfileTask task) {
        try {
            ProfileTaskFinishReport.Builder reportBuilder = ProfileTaskFinishReport.newBuilder();
            reportBuilder.setService(Config.Agent.SERVICE_NAME).setServiceInstance(Config.Agent.INSTANCE_NAME);
            reportBuilder.setTaskId(task.getTaskId());
            ((ProfileTaskGrpc.ProfileTaskBlockingStub)this.profileTaskBlockingStub.withDeadlineAfter(Config.Collector.GRPC_UPSTREAM_TIMEOUT, TimeUnit.SECONDS)).reportTaskFinish(reportBuilder.build());
        }
        catch (Throwable e) {
            LOGGER.error(e, "Notify profile task finish to backend fail.", new Object[0]);
        }
    }
}

