/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.thread;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.skywalking.apm.network.language.agent.v3.Thread;

public enum ThreadProvider {
    INSTANCE;

    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public Thread getThreadMetrics() {
        int runnableStateThreadCount = 0;
        int blockedStateThreadCount = 0;
        int waitingStateThreadCount = 0;
        int timedWaitingStateThreadCount = 0;
        ThreadInfo[] threadInfos = this.threadMXBean.getThreadInfo(this.threadMXBean.getAllThreadIds(), 0);
        if (threadInfos != null) {
            block6: for (ThreadInfo threadInfo : threadInfos) {
                if (threadInfo == null) continue;
                switch (threadInfo.getThreadState()) {
                    case RUNNABLE: {
                        ++runnableStateThreadCount;
                        continue block6;
                    }
                    case BLOCKED: {
                        ++blockedStateThreadCount;
                        continue block6;
                    }
                    case WAITING: {
                        ++waitingStateThreadCount;
                        continue block6;
                    }
                    case TIMED_WAITING: {
                        ++timedWaitingStateThreadCount;
                        continue block6;
                    }
                }
            }
        }
        int threadCount = this.threadMXBean.getThreadCount();
        int daemonThreadCount = this.threadMXBean.getDaemonThreadCount();
        int peakThreadCount = this.threadMXBean.getPeakThreadCount();
        return Thread.newBuilder().setLiveCount(threadCount).setDaemonCount(daemonThreadCount).setPeakCount(peakThreadCount).setRunnableStateThreadCount(runnableStateThreadCount).setBlockedStateThreadCount(blockedStateThreadCount).setWaitingStateThreadCount(waitingStateThreadCount).setTimedWaitingStateThreadCount(timedWaitingStateThreadCount).build();
    }
}

