/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class FslWindProfiler
extends CoordSysBuilder {
    public static boolean isMine(NetcdfFile ncfile) {
        String title = ncfile.findAttValueIgnoreCase(null, "title", null);
        return title != null && title.startsWith("WPDN data");
    }

    public FslWindProfiler() {
        this.conventionName = "FslWindProfiler";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        for (Variable v : ds.getVariables()) {
            switch (v.getShortName()) {
                case "staName": {
                    v.addAttribute(new Attribute("standard_name", "station_name"));
                    break;
                }
                case "staLat": {
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                    break;
                }
                case "staLon": {
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                    break;
                }
                case "staElev": 
                case "levels": {
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
                    break;
                }
                case "timeObs": {
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                }
            }
        }
        ds.finish();
    }
}

