/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.util.HashMap;
import java.util.Map;

public class TagEnum {
    private static Map<Short, TagEnum> hash = new HashMap<Short, TagEnum>(100);
    public static int SPECIAL_LINKED = 1;
    public static int SPECIAL_EXT = 2;
    public static int SPECIAL_COMP = 3;
    public static int SPECIAL_VLINKED = 4;
    public static int SPECIAL_CHUNKED = 5;
    public static int SPECIAL_BUFFERED = 6;
    public static int SPECIAL_COMPRAS = 7;
    public static int COMP_CODE_NONE;
    public static int COMP_CODE_RLE;
    public static int COMP_CODE_NBIT;
    public static int COMP_CODE_SKPHUFF;
    public static int COMP_CODE_DEFLATE;
    public static int COMP_CODE_SZIP;
    public static final TagEnum NONE;
    public static final TagEnum NULL;
    public static final TagEnum RLE;
    public static final TagEnum IMC;
    public static final TagEnum IMCOMP;
    public static final TagEnum JPEG;
    public static final TagEnum GREYJPEG;
    public static final TagEnum JPEG5;
    public static final TagEnum GREYJPEG5;
    public static final TagEnum LINKED;
    public static final TagEnum VERSION;
    public static final TagEnum COMPRESSED;
    public static final TagEnum VLINKED;
    public static final TagEnum VLINKED_DATA;
    public static final TagEnum CHUNKED;
    public static final TagEnum CHUNK;
    public static final TagEnum FID;
    public static final TagEnum FD;
    public static final TagEnum TID;
    public static final TagEnum TD;
    public static final TagEnum DIL;
    public static final TagEnum DIA;
    public static final TagEnum NT;
    public static final TagEnum MT;
    public static final TagEnum FREE;
    public static final TagEnum ID8;
    public static final TagEnum IP8;
    public static final TagEnum RI8;
    public static final TagEnum CI8;
    public static final TagEnum II8;
    public static final TagEnum ID;
    public static final TagEnum LUT;
    public static final TagEnum RI;
    public static final TagEnum CI;
    public static final TagEnum NRI;
    public static final TagEnum RIG;
    public static final TagEnum LD;
    public static final TagEnum MD;
    public static final TagEnum MA;
    public static final TagEnum CCN;
    public static final TagEnum CFM;
    public static final TagEnum AR;
    public static final TagEnum DRAW;
    public static final TagEnum RUN;
    public static final TagEnum XYP;
    public static final TagEnum MTO;
    public static final TagEnum T14;
    public static final TagEnum T105;
    public static final TagEnum SDG;
    public static final TagEnum SDD;
    public static final TagEnum SD;
    public static final TagEnum SDS;
    public static final TagEnum SDL;
    public static final TagEnum SDU;
    public static final TagEnum SDF;
    public static final TagEnum SDM;
    public static final TagEnum SDC;
    public static final TagEnum SDT;
    public static final TagEnum SDLNK;
    public static final TagEnum NDG;
    public static final TagEnum CAL;
    public static final TagEnum FV;
    public static final TagEnum BREQ;
    public static final TagEnum SDRAG;
    public static final TagEnum EREQ;
    public static final TagEnum VG;
    public static final TagEnum VH;
    public static final TagEnum VS;
    private String name;
    private String desc;
    private short code;

    private TagEnum(String name, String desc, short code) {
        this.name = name;
        this.desc = desc;
        this.code = code;
        hash.put(code, this);
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public short getCode() {
        return this.code;
    }

    public String toString() {
        return this.name + " (" + this.code + ") " + this.desc;
    }

    public static TagEnum getTag(short code) {
        TagEnum te = hash.get(code);
        if (te == null) {
            te = new TagEnum("UNKNOWN", "UNKNOWN", code);
        }
        return te;
    }

    static {
        COMP_CODE_RLE = 1;
        COMP_CODE_NBIT = 2;
        COMP_CODE_SKPHUFF = 3;
        COMP_CODE_DEFLATE = 4;
        COMP_CODE_SZIP = 5;
        NONE = new TagEnum("NONE", "", 0);
        NULL = new TagEnum("NULL", "", 1);
        RLE = new TagEnum("RLE", "Run length encoding", 11);
        IMC = new TagEnum("IMC", "IMCOMP compression alias", 12);
        IMCOMP = new TagEnum("IMCOMP", "IMCOMP compression", 12);
        JPEG = new TagEnum("JPEG", "JPEG compression (24-bit data)", 13);
        GREYJPEG = new TagEnum("GREYJPEG", "JPEG compression (8-bit data)", 14);
        JPEG5 = new TagEnum("JPEG5", "JPEG compression (24-bit data)", 15);
        GREYJPEG5 = new TagEnum("GREYJPEG5", "JPEG compression (8-bit data)", 16);
        LINKED = new TagEnum("LINKED", "Linked-block special element", 20);
        VERSION = new TagEnum("VERSION", "Version", 30);
        COMPRESSED = new TagEnum("COMPRESSED", "Compressed special element", 40);
        VLINKED = new TagEnum("VLINKED", "Variable-len linked-block header", 50);
        VLINKED_DATA = new TagEnum("VLINKED_DATA", "Variable-len linked-block data", 51);
        CHUNKED = new TagEnum("CHUNKED", "Chunked special element header", 60);
        CHUNK = new TagEnum("CHUNK", "Chunk element", 61);
        FID = new TagEnum("FID", "File identifier", 100);
        FD = new TagEnum("FD", "File description", 101);
        TID = new TagEnum("TID", "Tag identifier", 102);
        TD = new TagEnum("TD", "Tag descriptor", 103);
        DIL = new TagEnum("DIL", "Data identifier label", 104);
        DIA = new TagEnum("DIA", "Data identifier annotation", 105);
        NT = new TagEnum("NT", "Number type", 106);
        MT = new TagEnum("MT", "Machine type", 107);
        FREE = new TagEnum("FREE", "Free space in the file", 108);
        ID8 = new TagEnum("ID8", "8-bit Image dimension", 200);
        IP8 = new TagEnum("IP8", "8-bit Image palette", 201);
        RI8 = new TagEnum("RI8", "Raster-8 image", 202);
        CI8 = new TagEnum("CI8", "RLE compressed 8-bit image", 203);
        II8 = new TagEnum("II8", "IMCOMP compressed 8-bit image", 204);
        ID = new TagEnum("ID", "Image DimRec", 300);
        LUT = new TagEnum("LUT", "Image Palette", 301);
        RI = new TagEnum("RI", "Raster Image", 302);
        CI = new TagEnum("CI", "Compressed Image", 303);
        NRI = new TagEnum("NRI", "New-format Raster Image", 304);
        RIG = new TagEnum("RIG", "Raster Image Group", 306);
        LD = new TagEnum("LD", "Palette DimRec", 307);
        MD = new TagEnum("MD", "Matte DimRec", 308);
        MA = new TagEnum("MA", "Matte Data", 309);
        CCN = new TagEnum("CCN", "Color correction", 310);
        CFM = new TagEnum("CFM", "Color format", 311);
        AR = new TagEnum("AR", "Cspect ratio", 312);
        DRAW = new TagEnum("DRAW", "Draw these images in sequence", 400);
        RUN = new TagEnum("RUN", "Cun this as a program/script", 401);
        XYP = new TagEnum("XYP", "X-Y position", 500);
        MTO = new TagEnum("MTO", "Machine-type override", 501);
        T14 = new TagEnum("T14", "TEK 4014 data", 602);
        T105 = new TagEnum("T105", "TEK 4105 data", 603);
        SDG = new TagEnum("SDG", "Scientific Data Group", 700);
        SDD = new TagEnum("SDD", "Scientific Data DimRec", 701);
        SD = new TagEnum("SD", "Scientific Data", 702);
        SDS = new TagEnum("SDS", "Scales", 703);
        SDL = new TagEnum("SDL", "Labels", 704);
        SDU = new TagEnum("SDU", "Units", 705);
        SDF = new TagEnum("SDF", "Formats", 706);
        SDM = new TagEnum("SDM", "Max/Min", 707);
        SDC = new TagEnum("SDC", "Coord sys", 708);
        SDT = new TagEnum("SDT", "Transpose", 709);
        SDLNK = new TagEnum("SDLNK", "Links related to the dataset", 710);
        NDG = new TagEnum("NDG", "Numeric Data Group", 720);
        CAL = new TagEnum("CAL", "Calibration information", 731);
        FV = new TagEnum("FV", "Fill Value information", 732);
        BREQ = new TagEnum("BREQ", "Beginning of required tags", 799);
        SDRAG = new TagEnum("SDRAG", "List of ragged array line lengths", 781);
        EREQ = new TagEnum("EREQ", "Current end of the range", 780);
        VG = new TagEnum("VG", "Vgroup", 1965);
        VH = new TagEnum("VH", "Vdata Header", 1962);
        VS = new TagEnum("VS", "Vdata Storage", 1963);
    }
}

