/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions;

import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.expressions.Aggregator;
import org.apache.spark.sql.sedona_sql.expressions.TraitSTAggregateExec;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005U2A\u0001B\u0003\u0001%!)a\u0005\u0001C\u0001O!)\u0011\u0006\u0001C\u0001U!)q\u0006\u0001C\u0001a\t\u00012\u000bV0F]Z,Gn\u001c9f?\u0006;wM\u001d\u0006\u0003\r\u001d\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001\"C\u0001\u000bg\u0016$wN\\1`gFd'B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011c\u0001\u0001\u0014EA)AC\u0006\r\u001915\tQC\u0003\u0002\u0007\u0013%\u0011q#\u0006\u0002\u000b\u0003\u001e<'/Z4bi>\u0014\bCA\r!\u001b\u0005Q\"BA\u000e\u001d\u0003\u00119Wm\\7\u000b\u0005uq\u0012a\u00016ug*\u0011qdD\u0001\rY>\u001c\u0017\r^5p]R,7\r[\u0005\u0003Ci\u0011\u0001bR3p[\u0016$(/\u001f\t\u0003G\u0011j\u0011!B\u0005\u0003K\u0015\u0011A\u0003\u0016:bSR\u001cF+Q4he\u0016<\u0017\r^3Fq\u0016\u001c\u0017A\u0002\u001fj]&$h\bF\u0001)!\t\u0019\u0003!\u0001\u0004sK\u0012,8-\u001a\u000b\u00041-j\u0003\"\u0002\u0017\u0003\u0001\u0004A\u0012A\u00022vM\u001a,'\u000fC\u0003/\u0005\u0001\u0007\u0001$A\u0003j]B,H/A\u0003nKJ<W\rF\u0002\u0019cMBQAM\u0002A\u0002a\tqAY;gM\u0016\u0014\u0018\u0007C\u00035\u0007\u0001\u0007\u0001$A\u0004ck\u001a4WM\u001d\u001a")
public class ST_Envelope_Aggr
extends Aggregator<Geometry, Geometry, Geometry>
implements TraitSTAggregateExec {
    private Geometry initialGeometry;
    private ExpressionEncoder<Geometry> serde;

    @Override
    public Geometry zero() {
        return TraitSTAggregateExec.zero$(this);
    }

    @Override
    public ExpressionEncoder<Geometry> bufferEncoder() {
        return TraitSTAggregateExec.bufferEncoder$(this);
    }

    @Override
    public ExpressionEncoder<Geometry> outputEncoder() {
        return TraitSTAggregateExec.outputEncoder$(this);
    }

    @Override
    public Geometry finish(Geometry out) {
        return TraitSTAggregateExec.finish$(this, out);
    }

    @Override
    public Geometry initialGeometry() {
        return this.initialGeometry;
    }

    @Override
    public ExpressionEncoder<Geometry> serde() {
        return this.serde;
    }

    @Override
    public void org$apache$spark$sql$sedona_sql$expressions$TraitSTAggregateExec$_setter_$initialGeometry_$eq(Geometry x$1) {
        this.initialGeometry = x$1;
    }

    @Override
    public void org$apache$spark$sql$sedona_sql$expressions$TraitSTAggregateExec$_setter_$serde_$eq(ExpressionEncoder<Geometry> x$1) {
        this.serde = x$1;
    }

    public Geometry reduce(Geometry buffer, Geometry input) {
        Envelope accumulateEnvelope = buffer.getEnvelopeInternal();
        Envelope newEnvelope = input.getEnvelopeInternal();
        Coordinate[] coordinates = new Coordinate[5];
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        if (accumulateEnvelope.equals(this.initialGeometry().getEnvelopeInternal())) {
            minX = newEnvelope.getMinX();
            minY = newEnvelope.getMinY();
            maxX = newEnvelope.getMaxX();
            maxY = newEnvelope.getMaxY();
        } else if (newEnvelope.equals(this.initialGeometry().getEnvelopeInternal())) {
            minX = accumulateEnvelope.getMinX();
            minY = accumulateEnvelope.getMinY();
            maxX = accumulateEnvelope.getMaxX();
            maxY = accumulateEnvelope.getMaxY();
        } else {
            minX = Math.min(accumulateEnvelope.getMinX(), newEnvelope.getMinX());
            minY = Math.min(accumulateEnvelope.getMinY(), newEnvelope.getMinY());
            maxX = Math.max(accumulateEnvelope.getMaxX(), newEnvelope.getMaxX());
            maxY = Math.max(accumulateEnvelope.getMaxY(), newEnvelope.getMaxY());
        }
        coordinates[0] = new Coordinate(minX, minY);
        coordinates[1] = new Coordinate(minX, maxY);
        coordinates[2] = new Coordinate(maxX, maxY);
        coordinates[3] = new Coordinate(maxX, minY);
        coordinates[4] = coordinates[0];
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPolygon(coordinates);
    }

    public Geometry merge(Geometry buffer1, Geometry buffer2) {
        Envelope leftEnvelope = buffer1.getEnvelopeInternal();
        Envelope rightEnvelope = buffer2.getEnvelopeInternal();
        Coordinate[] coordinates = new Coordinate[5];
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        if (leftEnvelope.equals(this.initialGeometry().getEnvelopeInternal())) {
            minX = rightEnvelope.getMinX();
            minY = rightEnvelope.getMinY();
            maxX = rightEnvelope.getMaxX();
            maxY = rightEnvelope.getMaxY();
        } else if (rightEnvelope.equals(this.initialGeometry().getEnvelopeInternal())) {
            minX = leftEnvelope.getMinX();
            minY = leftEnvelope.getMinY();
            maxX = leftEnvelope.getMaxX();
            maxY = leftEnvelope.getMaxY();
        } else {
            minX = Math.min(leftEnvelope.getMinX(), rightEnvelope.getMinX());
            minY = Math.min(leftEnvelope.getMinY(), rightEnvelope.getMinY());
            maxX = Math.max(leftEnvelope.getMaxX(), rightEnvelope.getMaxX());
            maxY = Math.max(leftEnvelope.getMaxY(), rightEnvelope.getMaxY());
        }
        coordinates[0] = new Coordinate(minX, minY);
        coordinates[1] = new Coordinate(minX, maxY);
        coordinates[2] = new Coordinate(maxX, maxY);
        coordinates[3] = new Coordinate(maxX, minY);
        coordinates[4] = coordinates[0];
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPolygon(coordinates);
    }

    public ST_Envelope_Aggr() {
        TraitSTAggregateExec.$init$(this);
        Statics.releaseFence();
    }
}

