/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser;

import java.util.Arrays;
import java.util.List;
import org.apache.sedona.shaded.jiffle.parser.ConstantLookup;

class OptionInfo {
    public static final String ANY_STRING = "ANY_STRING";
    public static final String ANY_NUMBER = "ANY_NUMBER";
    public static final String NULL_KEYWORD = "NULL_KEYWORD";
    private final String name;
    private final List<String> validValues;

    public OptionInfo(String name, String[] validValues) {
        this.name = name;
        this.validValues = Arrays.asList(validValues);
    }

    public String getName() {
        return this.name;
    }

    public boolean isValidValue(String value) {
        if ("null".equalsIgnoreCase(value)) {
            return this.validValues.contains(NULL_KEYWORD);
        }
        if (ConstantLookup.isDefined(value)) {
            return this.validValues.contains(ANY_NUMBER);
        }
        boolean numeric = true;
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            numeric = false;
        }
        if (numeric) {
            return this.validValues.contains(ANY_NUMBER);
        }
        return this.validValues.contains(ANY_STRING);
    }
}

