/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.sedona_sql.io.geojson.GeoJSONUtils$;
import org.apache.spark.sql.sedona_sql.io.geojson.SparkCompatUtil$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001B\u000f\u001f\u00015B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B?\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!I\u0011Q\u0004\u0001C\u0002\u0013%\u0011q\u0004\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\"!Y\u0011q\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0019\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0004%I!!\u000e\t\u0015\u0005\u0005\u0003\u00011A\u0001B\u0003&!\u000eC\u0006\u0002D\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0003bCA)\u0001\u0001\u0007\t\u0019!C\u0005\u0003'B1\"a\u0016\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H!I\u0011\u0011\f\u0001A\u0002\u0013%\u00111\f\u0005\n\u0003[\u0002\u0001\u0019!C\u0005\u0003_B\u0001\"a\u001d\u0001A\u0003&\u0011Q\f\u0005\n\u0003k\u0002!\u0019!C\u0005\u0003oB\u0001\"!%\u0001A\u0003%\u0011\u0011\u0010\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\ti\n\u0001C!\u0003?Cq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002&\u0002!I!a*\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"I\u00111\u001a\u0001\u0012\u0002\u0013\u0005\u0011Q\u001a\u0005\b\u0003G\u0004A\u0011AAs\u0011\u001d\t\t\u0010\u0001C\u0001\u0003g\u00141c\u0015;bGB\u000b'\u000f^5uS>t'+Z1eKJT!a\b\u0011\u0002\tM$\u0018m\u0019\u0006\u0003C\t\n!![8\u000b\u0005\r\"\u0013AC:fI>t\u0017mX:rY*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\f\u001c\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001\u00027b]\u001eT\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t1qJ\u00196fGR\u00042a\u000e\u001f?\u001b\u0005A$BA\u001d;\u0003\u0011\u0011X-\u00193\u000b\u0005m\"\u0013!C2p]:,7\r^8s\u0013\ti\u0004HA\bQCJ$\u0018\u000e^5p]J+\u0017\rZ3s!\ty$)D\u0001A\u0015\t\tE%\u0001\u0005dCR\fG._:u\u0013\t\u0019\u0005IA\u0006J]R,'O\\1m%><\u0018!\u00032s_\u0006$7-Y:u!\r1\u0005JS\u0007\u0002\u000f*\u0011AIJ\u0005\u0003\u0013\u001e\u0013\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0005-sU\"\u0001'\u000b\u000553\u0013\u0001B;uS2L!a\u0014'\u00033M+'/[1mSj\f'\r\\3D_:4\u0017nZ;sCRLwN\\\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"AU*\u000e\u0003yI!\u0001\u0016\u0010\u0003\u001bM#\u0018m\u0019)beRLG/[8o\u0003\u0019\u00198\r[3nCB\u0011qKW\u0007\u00021*\u0011\u0011\fJ\u0001\u0006if\u0004Xm]\u0005\u00037b\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003\u0011y\u0007\u000f^:\u0011\ty;'N\u001b\b\u0003?\u0016\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0017\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0004\u001b\u0006\u0004(B\u00014d!\tq6.\u0003\u0002mS\n11\u000b\u001e:j]\u001e\fQb\u001d9bi&\fGNR5mi\u0016\u0014\bcA8qe6\t1-\u0003\u0002rG\n1q\n\u001d;j_:\u0004\"a\u001d>\u000e\u0003QT!!\u001e<\u0002\u000fA\f'/];fi*\u0011q\u000f_\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002zI\u0005IQ\r_3dkRLwN\\\u0005\u0003wR\u0014qcR3p!\u0006\u0014\u0018/^3u'B\fG/[1m\r&dG/\u001a:\u0002\u001dQ,W\u000e]8sC24\u0015\u000e\u001c;feB\u0019q\u000e\u001d@\u0011\u0007}\f9!\u0004\u0002\u0002\u0002)\u0019q$a\u0001\u000b\u0007\u0005\u0015\u00010\u0001\u0006eCR\f7o\\;sG\u0016LA!!\u0003\u0002\u0002\tqA+Z7q_J\fGNR5mi\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\b\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0011\u0005I\u0003\u0001\"\u0002#\b\u0001\u0004)\u0005\"\u0002)\b\u0001\u0004\t\u0006\"B+\b\u0001\u00041\u0006\"\u0002/\b\u0001\u0004i\u0006\"B7\b\u0001\u0004q\u0007\"\u0002?\b\u0001\u0004i\u0018!D5uK6\u001c\u0018\n^3sCR|'/\u0006\u0002\u0002\"A)\u00111EA\u0015U6\u0011\u0011Q\u0005\u0006\u0004\u0003O\u0019\u0017AC2pY2,7\r^5p]&!\u00111FA\u0013\u0005!IE/\u001a:bi>\u0014\u0018AD5uK6\u001c\u0018\n^3sCR|'\u000fI\u0001\fGV\u0014(/\u001a8u\u0013R,W.F\u0001k\u0003=\u0019WO\u001d:f]RLE/Z7`I\u0015\fH\u0003BA\u001c\u0003{\u00012a\\A\u001d\u0013\r\tYd\u0019\u0002\u0005+:LG\u000f\u0003\u0005\u0002@-\t\t\u00111\u0001k\u0003\rAH%M\u0001\rGV\u0014(/\u001a8u\u0013R,W\u000eI\u0001\fGV\u0014(/\u001a8u\r&dW-\u0006\u0002\u0002HA!\u0011\u0011JA'\u001b\t\tYE\u0003\u0002\"e%!\u0011qJA&\u0005\u00111\u0015\u000e\\3\u0002\u001f\r,(O]3oi\u001aKG.Z0%KF$B!a\u000e\u0002V!I\u0011q\b\b\u0002\u0002\u0003\u0007\u0011qI\u0001\rGV\u0014(/\u001a8u\r&dW\rI\u0001\u0010M\u0016\fG/\u001e:f\u0013R,'/\u0019;peV\u0011\u0011Q\f\t\u0006\u0003?\nIG\u0010\b\u0005\u0003C\n)GD\u0002a\u0003GJ\u0011\u0001Z\u0005\u0004\u0003O\u001a\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003W\tYGC\u0002\u0002h\r\f1CZ3biV\u0014X-\u0013;fe\u0006$xN]0%KF$B!a\u000e\u0002r!I\u0011qH\t\u0002\u0002\u0003\u0007\u0011QL\u0001\u0011M\u0016\fG/\u001e:f\u0013R,'/\u0019;pe\u0002\na!\\1qa\u0016\u0014XCAA=!\u0011\tY(!$\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0005\u0003\u0007\u000b))A\u0004kC\u000e\\7o\u001c8\u000b\t\u0005\u001d\u0015\u0011R\u0001\nM\u0006\u001cH/\u001a:y[2T!!a#\u0002\u0007\r|W.\u0003\u0003\u0002\u0010\u0006u$\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\u0018aB7baB,'\u000fI\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0002\u0018B\u0019q.!'\n\u0007\u0005m5MA\u0004C_>dW-\u00198\u0002\u0007\u001d,G\u000fF\u0001?\u0003\u0015\u0019Gn\\:f)\t\t9$\u0001\fdQ\u0016\u001c7.\u00118e\t\u0016dW\r^3UK6\u0004h)\u001b7f)\u0011\t9$!+\t\u000f\u0005-\u0006\u00041\u0001\u0002H\u0005!a-\u001b7f\u0003U1W\r^2i\u0007>tG/\u001a8u/&$\bNU3uef$RA[AY\u0003\u0003Dq!a-\u001a\u0001\u0004\t),A\u0002ve2\u0004B!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w\u0013\u0014a\u00018fi&!\u0011qXA]\u0005\r)&\u000b\u0014\u0005\n\u0003\u0007L\u0002\u0013!a\u0001\u0003\u000b\f!\"\\1y%\u0016$(/[3t!\ry\u0017qY\u0005\u0004\u0003\u0013\u001c'aA%oi\u0006yb-\u001a;dQ\u000e{g\u000e^3oi^KG\u000f\u001b*fiJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005='\u0006BAc\u0003#\\#!a5\u0011\t\u0005U\u0017q\\\u0007\u0003\u0003/TA!!7\u0002\\\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\u001c\u0017AC1o]>$\u0018\r^5p]&!\u0011\u0011]Al\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016GJ,\u0017\r^3QCJ$\u0018\u000e^5p]\u0016$g)\u001b7f)\u0011\t9/a<\u0011\t\u0005%\u00181^\u0007\u0002m&\u0019\u0011Q\u001e<\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016Dq!a\u0011\u001c\u0001\u0004\t9%A\bde\u0016\fG/Z*qCJ\\\u0007+\u0019;i)\rq\u0013Q\u001f\u0005\u0007\u0003od\u0002\u0019\u00016\u0002\u0015A\fG\u000f[*ue&tw\r")
public class StacPartitionReader
implements PartitionReader<InternalRow> {
    private final StructType schema;
    private final Map<String, String> opts;
    private final Iterator<String> itemsIterator;
    private String currentItem;
    private File currentFile;
    private Iterator<InternalRow> featureIterator;
    private final ObjectMapper mapper;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private Iterator<String> itemsIterator() {
        return this.itemsIterator;
    }

    private String currentItem() {
        return this.currentItem;
    }

    private void currentItem_$eq(String x$1) {
        this.currentItem = x$1;
    }

    private File currentFile() {
        return this.currentFile;
    }

    private void currentFile_$eq(File x$1) {
        this.currentFile = x$1;
    }

    private Iterator<InternalRow> featureIterator() {
        return this.featureIterator;
    }

    private void featureIterator_$eq(Iterator<InternalRow> x$1) {
        this.featureIterator = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public boolean next() {
        boolean bl;
        if (this.featureIterator().hasNext()) {
            bl = true;
        } else if (this.itemsIterator().hasNext()) {
            Iterator iterator;
            File tempFile;
            this.currentItem_$eq((String)this.itemsIterator().next());
            if (this.currentItem().startsWith("http://") || this.currentItem().startsWith("https://") || this.currentItem().startsWith("file://")) {
                URL url = new URL(this.currentItem());
                tempFile = File.createTempFile("stac_item_", ".json");
                try (PrintWriter writer = new PrintWriter(tempFile);){
                    String nodeType;
                    String fileContent = this.fetchContentWithRetry(url, this.fetchContentWithRetry$default$2());
                    JsonNode rootNode = this.mapper().readTree(fileContent);
                    String string = nodeType = rootNode.get("type").asText();
                    if ("Feature".equals(string)) {
                        String content = this.mapper().writeValueAsString((Object)rootNode);
                        writer.write(content);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    if ("FeatureCollection".equals(string)) {
                        JsonNode features = rootNode.get("features");
                        java.util.Iterator featureIterator = features.elements();
                        while (featureIterator.hasNext()) {
                            JsonNode feature = (JsonNode)featureIterator.next();
                            String content = this.mapper().writeValueAsString((Object)feature);
                            writer.write(content);
                            writer.write("\n");
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported type for item: ").append(nodeType).toString());
                }
            } else {
                throw new IllegalArgumentException(new StringBuilder(31).append("Unsupported protocol for item: ").append(this.currentItem()).toString());
            }
            this.checkAndDeleteTempFile(this.currentFile());
            this.currentFile_$eq(tempFile);
            if (this.currentFile().exists()) {
                JSONOptionsInRead parsedOptions = new JSONOptionsInRead(this.opts, (String)this.opts.getOrElse((Object)"sessionLocalTimeZone", (Function0 & Serializable & scala.Serializable)() -> "UTC"), (String)this.opts.getOrElse((Object)"columnNameOfCorruptRecord", (Function0 & Serializable & scala.Serializable)() -> "_corrupt_record"));
                JsonDataSource dataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
                StructType alteredSchema = GeoJSONUtils$.MODULE$.updateGeometrySchema(this.schema, (DataType)StringType$.MODULE$);
                JacksonParser parser = SparkCompatUtil$.MODULE$.constructJacksonParser((DataType)alteredSchema, (JSONOptions)parsedOptions, true);
                Iterator<InternalRow> rows = SparkCompatUtil$.MODULE$.readFile(dataSource, new Configuration(), this.createPartitionedFile(this.currentFile()), parser, this.schema);
                iterator = rows.map((Function1 & Serializable & scala.Serializable)row -> {
                    void var3_3;
                    InternalRow geometryConvertedRow = GeoJSONUtils$.MODULE$.convertGeoJsonToGeometry((InternalRow)row, alteredSchema);
                    InternalRow propertiesPromotedRow = StacUtils$.MODULE$.promotePropertiesToTop(geometryConvertedRow, alteredSchema);
                    return var3_3;
                });
            } else {
                iterator = package$.MODULE$.Iterator().empty();
            }
            this.featureIterator_$eq((Iterator<InternalRow>)iterator);
            bl = this.next();
        } else {
            bl = false;
        }
        return bl;
    }

    public InternalRow get() {
        return (InternalRow)this.featureIterator().next();
    }

    public void close() {
        this.checkAndDeleteTempFile(this.currentFile());
    }

    private void checkAndDeleteTempFile(File file) {
        block0: {
            if (file == null || !file.exists() || !file.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir"))) break block0;
            file.delete();
        }
    }

    public String fetchContentWithRetry(URL url, int maxRetries) {
        int attempt = 0;
        boolean success = false;
        String fileContent = "";
        while (attempt < maxRetries && !success) {
            try {
                fileContent = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                success = true;
            }
            catch (Exception e) {
                if (++attempt < maxRetries) continue;
                throw new RuntimeException(new StringBuilder(48).append("Failed to fetch content from URL after ").append(maxRetries).append(" attempts").toString(), e);
            }
        }
        return fileContent;
    }

    public int fetchContentWithRetry$default$2() {
        return 3;
    }

    public PartitionedFile createPartitionedFile(File currentFile) {
        Object[] objectArray;
        Class<?> partitionedFileClass = Class.forName("org.apache.spark.sql.execution.datasources.PartitionedFile");
        Constructor[] constructors = partitionedFileClass.getConstructors();
        Constructor constructor = (Constructor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])constructors)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StacPartitionReader.$anonfun$createPartitionedFile$1(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Constructor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])constructors)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StacPartitionReader.$anonfun$createPartitionedFile$3(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NoSuchMethodException("No constructor with 7 or 8 parameters found");
        }));
        if (constructor.getParameterCount() == 7) {
            Class<?> secondParamType = constructor.getParameterTypes()[1];
            String string = secondParamType.getName();
            String string2 = "org.apache.spark.paths.SparkPath";
            objectArray = !(string != null ? !string.equals(string2) : string2 != null) ? new Object[]{null, this.createSparkPath(currentFile.getPath()), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L} : new Object[]{null, currentFile.getPath(), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L};
        } else {
            objectArray = new Object[]{null, this.createSparkPath(currentFile.getPath()), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L, null};
        }
        Object[] params = objectArray;
        return (PartitionedFile)constructor.newInstance(params);
    }

    public Object createSparkPath(String pathString) {
        Class<?> sparkPathClass = Class.forName("org.apache.spark.paths.SparkPath");
        Constructor<?> constructor = sparkPathClass.getDeclaredConstructor(String.class);
        constructor.setAccessible(true);
        return constructor.newInstance(pathString);
    }

    public static final /* synthetic */ boolean $anonfun$createPartitionedFile$1(Constructor x$1) {
        return x$1.getParameterCount() == 7;
    }

    public static final /* synthetic */ boolean $anonfun$createPartitionedFile$3(Constructor x$2) {
        return x$2.getParameterCount() == 8;
    }

    public StacPartitionReader(Broadcast<SerializableConfiguration> broadcast, StacPartition partition, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        this.schema = schema;
        this.opts = opts;
        this.itemsIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partition.items())).iterator();
        this.featureIterator = package$.MODULE$.Iterator().empty();
        this.mapper = new ObjectMapper();
    }
}

