/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.index.rocksdb;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.index.QueryOffsetResult;
import org.apache.rocketmq.store.index.rocksdb.IndexRocksDBRecord;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.rocksdb.MessageRocksDBStorage;
import org.rocksdb.RocksDB;

public class IndexRocksDBStore {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final int DEFAULT_CAPACITY = 100000;
    private static final int BATCH_SIZE = 1000;
    private static final Set<String> INDEX_TYPE_SET = new HashSet<String>();
    private static final int INITIAL = 0;
    private static final int RUNNING = 1;
    private static final int SHUTDOWN = 2;
    private volatile int state = 0;
    private final MessageStore messageStore;
    private final MessageStoreConfig storeConfig;
    private final MessageRocksDBStorage messageRocksDBStorage;
    private volatile long lastDeleteIndexTime = 0L;
    private IndexBuildService indexBuildService;
    private BlockingQueue<IndexRocksDBRecord> originIndexMsgQueue;

    public IndexRocksDBStore(MessageStore messageStore) {
        this.messageStore = messageStore;
        this.storeConfig = messageStore.getMessageStoreConfig();
        this.messageRocksDBStorage = messageStore.getMessageRocksDBStorage();
        if (this.storeConfig.isIndexRocksDBEnable()) {
            this.initAndStart();
        }
    }

    private void initAndStart() {
        if (this.state == 1) {
            return;
        }
        this.indexBuildService = new IndexBuildService();
        this.originIndexMsgQueue = new LinkedBlockingDeque<IndexRocksDBRecord>(100000);
        this.indexBuildService.start();
        this.state = 1;
        Long lastOffsetPy = this.messageRocksDBStorage.getLastOffsetPy(RocksDB.DEFAULT_COLUMN_FAMILY);
        log.info("IndexRocksDBStore start success, lastOffsetPy: {}", (Object)lastOffsetPy);
    }

    public void shutdown() {
        if (this.state != 1 || this.state == 2) {
            return;
        }
        if (null != this.indexBuildService) {
            this.indexBuildService.shutdown();
        }
        this.state = 2;
        log.info("IndexRocksDBStore shutdown success");
    }

    public QueryOffsetResult queryOffset(String topic, String key, int maxNum, long beginTime, long endTime, String indexType, String lastKey) {
        if (StringUtils.isEmpty((CharSequence)topic) || StringUtils.isEmpty((CharSequence)key) || maxNum <= 0 || beginTime < 0L || endTime <= 0L || beginTime > endTime || !StringUtils.isEmpty((CharSequence)indexType) && !INDEX_TYPE_SET.contains(indexType)) {
            logError.error("IndexRocksDBStore queryOffset param error, topic: {}, key: {}, maxNum: {}, beginTime: {}, endTime: {}, indexType: {}, lastKey: {}", new Object[]{topic, key, maxNum, beginTime, endTime, indexType, lastKey});
            return null;
        }
        if (beginTime == 0L || Long.MAX_VALUE == endTime) {
            endTime = System.currentTimeMillis();
            beginTime = endTime - TimeUnit.DAYS.toMillis(this.storeConfig.getMaxRocksDBIndexQueryDays());
        }
        if (endTime - beginTime > TimeUnit.DAYS.toMillis(this.storeConfig.getMaxRocksDBIndexQueryDays())) {
            logError.error("IndexRocksDBStore queryOffset index in rocksdb, can not query more than: {} days", (Object)this.storeConfig.getMaxRocksDBIndexQueryDays());
            return null;
        }
        long lastUpdateTime = 0L;
        long lastOffsetPy = 0L;
        maxNum = Math.min(maxNum, this.storeConfig.getMaxMsgsNumBatch());
        List<Long> phyOffsets = null;
        try {
            lastUpdateTime = this.messageRocksDBStorage.getLastStoreTimeStampForIndex(RocksDB.DEFAULT_COLUMN_FAMILY);
            lastOffsetPy = this.messageRocksDBStorage.getLastOffsetPy(RocksDB.DEFAULT_COLUMN_FAMILY);
            if (StringUtils.isEmpty((CharSequence)indexType)) {
                phyOffsets = this.messageRocksDBStorage.queryOffsetForIndex(RocksDB.DEFAULT_COLUMN_FAMILY, topic, "K", key, beginTime, endTime, maxNum, null);
                if (CollectionUtils.isEmpty(phyOffsets)) {
                    phyOffsets = this.messageRocksDBStorage.queryOffsetForIndex(RocksDB.DEFAULT_COLUMN_FAMILY, topic, "U", key, beginTime, endTime, maxNum, null);
                }
            } else {
                phyOffsets = this.messageRocksDBStorage.queryOffsetForIndex(RocksDB.DEFAULT_COLUMN_FAMILY, topic, indexType, key, beginTime, endTime, maxNum, lastKey);
            }
        }
        catch (Exception e) {
            logError.error("IndexRocksDBStore queryOffset error, topic: {}, key: {}, maxNum: {}, beginTime: {}, endTime: {}, error: {}", new Object[]{topic, key, maxNum, beginTime, endTime, e.getMessage()});
        }
        return new QueryOffsetResult(phyOffsets, lastUpdateTime, lastOffsetPy);
    }

    public void buildIndex(DispatchRequest dispatchRequest) {
        if (null == dispatchRequest || dispatchRequest.getCommitLogOffset() < 0L || dispatchRequest.getMsgSize() <= 0 || this.state != 1 || null == this.originIndexMsgQueue) {
            logError.error("IndexRocksDBStore buildIndex error, dispatchRequest: {}, state: {}, originIndexMsgQueue: {}", new Object[]{dispatchRequest, this.state, this.originIndexMsgQueue});
            return;
        }
        try {
            String tags;
            Map<String, String> propertiesMap;
            String[] keySplit;
            long reqOffsetPy = dispatchRequest.getCommitLogOffset();
            long endOffsetPy = this.messageRocksDBStorage.getLastOffsetPy(RocksDB.DEFAULT_COLUMN_FAMILY);
            if (reqOffsetPy < endOffsetPy) {
                if (System.currentTimeMillis() % 1000L == 0L) {
                    log.warn("IndexRocksDBStore recover buildIndex, but ignore, build index offset reqOffsetPy: {}, endOffsetPy: {}", (Object)reqOffsetPy, (Object)endOffsetPy);
                }
                return;
            }
            int tranType = MessageSysFlag.getTransactionValue((int)dispatchRequest.getSysFlag());
            switch (tranType) {
                case 0: 
                case 4: 
                case 8: {
                    break;
                }
                case 12: {
                    return;
                }
            }
            String topic = dispatchRequest.getTopic();
            String uniqKey = dispatchRequest.getUniqKey();
            long storeTime = dispatchRequest.getStoreTimestamp();
            if (StringUtils.isEmpty((CharSequence)topic) || StringUtils.isEmpty((CharSequence)uniqKey) || storeTime <= 0L || reqOffsetPy < 0L) {
                return;
            }
            String keys = dispatchRequest.getKeys();
            if (!StringUtils.isEmpty((CharSequence)keys) && (keySplit = keys.split(" ")).length > 0) {
                Set keySet = Arrays.stream(keySplit).filter(i -> !StringUtils.isEmpty((CharSequence)i)).collect(Collectors.toSet());
                for (String key : keySet) {
                    try {
                        while (!this.originIndexMsgQueue.offer(new IndexRocksDBRecord(topic, key, null, storeTime, uniqKey, reqOffsetPy), 3L, TimeUnit.SECONDS)) {
                            if (System.currentTimeMillis() % 1000L != 0L) continue;
                            logError.error("IndexRocksDBStore buildIndex keys error, topic: {}, key: {}, storeTime: {}, uniqKey: {}, reqOffsetPy: {}", new Object[]{topic, key, storeTime, uniqKey, reqOffsetPy});
                        }
                    }
                    catch (Exception e) {
                        logError.error("IndexRocksDBStore buildIndex keys error, key: {}, uniqKey: {}, topic: {}, error: {}", new Object[]{key, uniqKey, topic, e.getMessage()});
                    }
                }
            }
            if (null != (propertiesMap = dispatchRequest.getPropertiesMap()) && propertiesMap.containsKey("TAGS") && !StringUtils.isEmpty((CharSequence)(tags = propertiesMap.get("TAGS")))) {
                try {
                    while (!this.originIndexMsgQueue.offer(new IndexRocksDBRecord(topic, null, tags, storeTime, uniqKey, reqOffsetPy), 3L, TimeUnit.SECONDS)) {
                        if (System.currentTimeMillis() % 1000L != 0L) continue;
                        logError.error("IndexRocksDBStore buildIndex offer tags error, topic: {}, tags: {}, storeTime: {}, uniqKey: {}, reqOffsetPy: {}", new Object[]{topic, tags, storeTime, uniqKey, reqOffsetPy});
                    }
                }
                catch (Exception e) {
                    logError.error("IndexRocksDBStore buildIndex tags error, tags: {}, uniqKey: {}, topic: {}, error: {}", new Object[]{tags, uniqKey, topic, e.getMessage()});
                }
            }
            try {
                while (!this.originIndexMsgQueue.offer(new IndexRocksDBRecord(topic, null, null, storeTime, uniqKey, reqOffsetPy), 3L, TimeUnit.SECONDS)) {
                    if (System.currentTimeMillis() % 1000L != 0L) continue;
                    logError.error("IndexRocksDBStore buildIndex uniqKey error, topic: {}, storeTime: {}, uniqKey: {}, reqOffsetPy: {}", new Object[]{topic, storeTime, uniqKey, reqOffsetPy});
                }
            }
            catch (Exception e) {
                logError.error("IndexRocksDBStore buildIndex uniqKey error: {}", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            logError.error("IndexRocksDBStore buildIndex error: {}", (Object)e.getMessage());
        }
    }

    public void deleteExpiredIndex() {
        try {
            MappedFile mappedFile = this.messageStore.getCommitLog().getEarliestMappedFile();
            if (null == mappedFile) {
                logError.info("IndexRocksDBStore deleteExpiredIndex mappedFile is null");
                return;
            }
            File file = mappedFile.getFile();
            if (null == file || StringUtils.isEmpty((CharSequence)file.getAbsolutePath())) {
                logError.info("IndexRocksDBStore deleteExpiredIndex error, file is null");
                return;
            }
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            long deleteIndexFileTime = attrs.creationTime().toMillis() - TimeUnit.HOURS.toMillis(1L);
            long desDeleteTimeHour = MixAll.dealTimeToHourStamps((long)deleteIndexFileTime);
            if (desDeleteTimeHour != this.lastDeleteIndexTime) {
                this.messageRocksDBStorage.deleteRecordsForIndex(RocksDB.DEFAULT_COLUMN_FAMILY, desDeleteTimeHour, 168);
                this.lastDeleteIndexTime = desDeleteTimeHour;
            } else {
                log.info("IndexRocksDBStore ignore this delete, lastDeleteIndexTime: {}, desDeleteTimeHour: {}", (Object)this.lastDeleteIndexTime, (Object)desDeleteTimeHour);
            }
        }
        catch (Exception e) {
            logError.error("IndexRocksDBStore deleteExpiredIndex rocksdb error: {}", (Object)e.getMessage());
        }
    }

    public boolean isMappedFileMatchedRecover(long phyOffset) {
        if (!this.storeConfig.isIndexRocksDBEnable()) {
            return true;
        }
        Long lastOffsetPy = this.messageRocksDBStorage.getLastOffsetPy(RocksDB.DEFAULT_COLUMN_FAMILY);
        log.info("index isMappedFileMatchedRecover lastOffsetPy: {}", (Object)lastOffsetPy);
        if (null != lastOffsetPy && phyOffset <= lastOffsetPy) {
            log.info("isMappedFileMatchedRecover IndexRocksDBStore recover form this offset, phyOffset: {}, lastOffsetPy: {}", (Object)phyOffset, (Object)lastOffsetPy);
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    private String getServiceThreadName() {
        DefaultMessageStore messageStore;
        String brokerIdentifier = "";
        if (this.messageStore instanceof DefaultMessageStore && (messageStore = (DefaultMessageStore)this.messageStore).getBrokerConfig().isInBrokerContainer()) {
            brokerIdentifier = messageStore.getBrokerConfig().getIdentifier();
        }
        return brokerIdentifier;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static {
        INDEX_TYPE_SET.add("K");
        INDEX_TYPE_SET.add("T");
        INDEX_TYPE_SET.add("U");
    }

    private class IndexBuildService
    extends ServiceThread {
        private final Logger log = IndexRocksDBStore.access$100();
        private List<IndexRocksDBRecord> irs;

        private IndexBuildService() {
        }

        public String getServiceName() {
            return IndexRocksDBStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            this.log.info(this.getServiceName() + " service start");
            this.irs = new ArrayList<IndexRocksDBRecord>(1000);
            while (!this.isStopped() || !IndexRocksDBStore.this.originIndexMsgQueue.isEmpty()) {
                try {
                    this.pollAndPutIndexRequest();
                }
                catch (Exception e) {
                    this.irs.clear();
                    logError.error("IndexRocksDBStore error occurred in: {}, error: {}", (Object)this.getServiceName(), (Object)e.getMessage());
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }

        private void pollAndPutIndexRequest() {
            this.pollIndexRecord();
            if (CollectionUtils.isEmpty(this.irs)) {
                return;
            }
            try {
                IndexRocksDBStore.this.messageRocksDBStorage.writeRecordsForIndex(RocksDB.DEFAULT_COLUMN_FAMILY, this.irs);
            }
            catch (Exception e) {
                logError.error("IndexRocksDBStore IndexBuildService pollAndPutIndexRequest error: {}", (Object)e.getMessage());
            }
            this.irs.clear();
        }

        private void pollIndexRecord() {
            block3: {
                try {
                    IndexRocksDBRecord tmpReq;
                    IndexRocksDBRecord firstReq = (IndexRocksDBRecord)IndexRocksDBStore.this.originIndexMsgQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (null == firstReq) break block3;
                    this.irs.add(firstReq);
                    while (null != (tmpReq = (IndexRocksDBRecord)IndexRocksDBStore.this.originIndexMsgQueue.poll(100L, TimeUnit.MILLISECONDS))) {
                        this.irs.add(tmpReq);
                        if (this.irs.size() < 1000) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    logError.error("IndexRocksDBStore IndexBuildService error: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

