/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsMessageDispatcher;
import org.apache.qpid.jms.meta.JmsAbstractResource;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.policy.JmsDefaultDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsDefaultRedeliveryPolicy;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;

public final class JmsConsumerInfo
extends JmsAbstractResource
implements Comparable<JmsConsumerInfo> {
    private final JmsConsumerId consumerId;
    private JmsDestination destination;
    private int prefetchSize;
    private boolean browser;
    private String selector;
    private boolean explicitClientID;
    private String subscriptionName;
    private boolean durable;
    private boolean shared;
    private boolean noLocal;
    private int acknowledgementMode;
    private boolean localMessageExpiry;
    private boolean presettle;
    private boolean connectionConsumer;
    private int maxMessages;
    private volatile boolean listener;
    private JmsRedeliveryPolicy redeliveryPolicy;
    private JmsDeserializationPolicy deserializationPolicy;
    private transient long lastDeliveredSequenceId;
    private final JmsMessageDispatcher dispatcher;

    public JmsConsumerInfo(JmsConsumerId consumerId, JmsMessageDispatcher dispatcher) {
        if (consumerId == null) {
            throw new IllegalArgumentException("Consumer ID cannot be null");
        }
        this.consumerId = consumerId;
        this.dispatcher = dispatcher;
    }

    public JmsConsumerInfo copy() {
        JmsConsumerInfo info = new JmsConsumerInfo(this.consumerId, this.dispatcher);
        this.copy(info);
        return info;
    }

    private void copy(JmsConsumerInfo info) {
        info.destination = this.destination;
        info.prefetchSize = this.prefetchSize;
        info.browser = this.browser;
        info.selector = this.selector;
        info.explicitClientID = this.explicitClientID;
        info.durable = this.durable;
        info.subscriptionName = this.subscriptionName;
        info.noLocal = this.noLocal;
        info.shared = this.shared;
        info.acknowledgementMode = this.acknowledgementMode;
        info.lastDeliveredSequenceId = this.lastDeliveredSequenceId;
        info.redeliveryPolicy = this.getRedeliveryPolicy().copy();
        info.deserializationPolicy = this.getDeserializationPolicy().copy();
        info.listener = this.listener;
        info.connectionConsumer = this.connectionConsumer;
        info.maxMessages = this.maxMessages;
    }

    @Override
    public JmsConsumerId getId() {
        return this.consumerId;
    }

    public boolean isBrowser() {
        return this.browser;
    }

    public void setBrowser(boolean browser) {
        this.browser = browser;
    }

    public boolean isListener() {
        return this.listener;
    }

    public void setListener(boolean listener) {
        this.listener = listener;
    }

    public JmsDestination getDestination() {
        return this.destination;
    }

    public void setDestination(JmsDestination destination) {
        this.destination = destination;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean isExplicitClientID() {
        return this.explicitClientID;
    }

    public void setExplicitClientID(boolean explicitClientID) {
        this.explicitClientID = explicitClientID;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String durableSubscriptionId) {
        this.subscriptionName = durableSubscriptionId;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void setLastDeliveredSequenceId(long lastDeliveredSequenceId) {
        this.lastDeliveredSequenceId = lastDeliveredSequenceId;
    }

    public long getLastDeliveredSequenceId() {
        return this.lastDeliveredSequenceId;
    }

    public JmsSessionId getParentId() {
        return this.consumerId.getParentId();
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isLocalMessageExpiry() {
        return this.localMessageExpiry;
    }

    public void setLocalMessageExpiry(boolean localMessageExpiry) {
        this.localMessageExpiry = localMessageExpiry;
    }

    public JmsRedeliveryPolicy getRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new JmsDefaultRedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(JmsRedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public JmsDeserializationPolicy getDeserializationPolicy() {
        if (this.deserializationPolicy == null) {
            this.deserializationPolicy = new JmsDefaultDeserializationPolicy();
        }
        return this.deserializationPolicy;
    }

    public void setDeserializationPolicy(JmsDeserializationPolicy deserializationPolicy) {
        this.deserializationPolicy = deserializationPolicy;
    }

    public boolean isPresettle() {
        return this.presettle;
    }

    public void setPresettle(boolean presettle) {
        this.presettle = presettle;
    }

    public boolean isConnectionConsumer() {
        return this.connectionConsumer;
    }

    public void setConnectionConsumer(boolean connectionConsumer) {
        this.connectionConsumer = connectionConsumer;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public JmsMessageDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public String toString() {
        return "JmsConsumerInfo: { " + String.valueOf(this.getId()) + ", destination = " + String.valueOf(this.getDestination()) + " }";
    }

    public int hashCode() {
        return this.consumerId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsConsumerInfo other = (JmsConsumerInfo)obj;
        return this.consumerId.equals(other.consumerId);
    }

    @Override
    public int compareTo(JmsConsumerInfo other) {
        return this.consumerId.compareTo(other.consumerId);
    }

    @Override
    public void visit(JmsResourceVistor vistor) throws Exception {
        vistor.processConsumerInfo(this);
    }
}

