/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertNull;
import static org.w3c.domts.DOMTest.load;


/**
 * The "setAttributeNodeNS(newAttr)" adds a new attribute.
 * If an attribute with that local name and that namespaceURI is already
 * present in the element, it is replaced by the new one.
 * <p>
 * Retrieve the first emp:address element and add a new attribute
 * to the element.  Since an attribute with the same local name
 * and namespaceURI as the newly created attribute does not exist
 * the value "null" is returned.
 * This test uses the "createAttributeNS(namespaceURI,localName)
 * method from the Document interface to create the new attribute to add.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
 */
public class setAttributeNodeNS03 {
    @Test
    void testRun() throws Throwable {
        String namespaceURI = "http://www.newattr.com";
        String qualifiedName = "emp:newAttr";
        Document doc = load("staffNS", true);
        NodeList elementList = doc.getElementsByTagName("emp:address");
        Node testAddr = elementList.item(0);
        Attr newAttr = doc.createAttributeNS(namespaceURI, qualifiedName);
        Attr newAddrAttr = ((Element) /*Node */testAddr).setAttributeNodeNS(newAttr);
        assertNull(newAddrAttr, "throw_Null");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setAttributeNodeNS03";
    }

}
