/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertNull;
import static org.w3c.domts.DOMTest.load;


/**
 * The method getOwnerDocument returns the Document object associated with this node
 * Create a new Document node.  Since this node is not used with any Document yet
 * verify if the ownerDocument is null.  Create a new element Node on the new Document
 * object.  Check the ownerDocument of the new element node.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#node-ownerDoc">http://www.w3.org/TR/DOM-Level-2-Core/core#node-ownerDoc</a>
 * @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=259">http://www.w3.org/Bugs/Public/show_bug.cgi?id=259</a>
 */
public class nodegetownerdocument02 {
    @Test
    void testRun() throws Throwable {
        String nullNS = null;

        Document doc = load("staff", false);
        DOMImplementation domImpl = doc.getImplementation();
        // TODO: fix when Doctypes are available
        DocumentType docType = null;// domImpl.createDocumentType("mydoc", nullNS, nullNS);
        Document newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "mydoc", docType);
        Document ownerDocDoc = newDoc.getOwnerDocument();
        assertNull(ownerDocDoc, "nodegetownerdocument02_1");
        Element newElem = newDoc.createElementNS("http://www.w3.org/DOM/Test", "myelem");
        Document ownerDocElem = newElem.getOwnerDocument();
        assertNotNull(ownerDocElem, "nodegetownerdocument02_2");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/nodegetownerdocument02";
    }

}
