/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The method getAttributeNodeNS retrieves an Attr node by local name and namespace URI.
 * Create a new element node and add 2 new attribute nodes to it that have the same
 * local name but different namespaceURIs and prefixes.
 * Retrieve an attribute using namespace and localname and check its value, name and
 * namespaceURI.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElGetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElGetAtNodeNS</a>
 */
public class elementgetattributenodens01 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", false);
        Element element = doc.createElementNS("namespaceURI", "root");
        Attr attribute1 = doc.createAttributeNS("http://www.w3.org/DOM/Level2", "l2:att");
        Attr newAttribute1 = element.setAttributeNodeNS(attribute1);
        Attr attribute2 = doc.createAttributeNS("http://www.w3.org/DOM/Level1", "att");
        Attr newAttribute2 = element.setAttributeNodeNS(attribute2);
        Attr attribute = element.getAttributeNodeNS("http://www.w3.org/DOM/Level2", "att");
        String attrValue = attribute.getNodeValue();
        String attrName = attribute.getName();
        String attNodeName = attribute.getNodeName();
        String attrLocalName = attribute.getLocalName();
        String attrNS = attribute.getNamespaceURI();
        assertEquals("", attrValue, "elementgetattributenodens01_attrValue");
        assertEquals("l2:att", attrName, "elementgetattributenodens01_attrName");
        assertEquals("l2:att", attNodeName, "elementgetattributenodens01_attrNodeName");
        assertEquals("att", attrLocalName, "elementgetattributenodens01_attrLocalName");
        assertEquals("http://www.w3.org/DOM/Level2", attrNS, "elementgetattributenodens01_attrNs");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementgetattributenodens01";
    }

}
