/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.piggybank.storage.avro.PigAvroDatumWriter;
import org.apache.pig.piggybank.storage.avro.PigAvroRecordWriter;

public class PigAvroOutputFormat
extends FileOutputFormat<NullWritable, Object> {
    public static final String EXT = ".avro";
    public static final String DEFLATE_LEVEL_KEY = "avro.mapred.deflate.level";
    public static final int DEFAULT_DEFLATE_LEVEL = 1;
    public static final String OUTPUT_CODEC = "avro.output.codec";
    public static final String DEFLATE_CODEC = "deflate";
    public static final String SYNC_INTERVAL_KEY = "avro.mapred.sync.interval";
    private Schema schema = null;

    public PigAvroOutputFormat() {
    }

    public PigAvroOutputFormat(Schema s) {
        this.schema = s;
    }

    public static void setDeflateLevel(Job job, int level) {
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        job.getConfiguration().setInt(DEFLATE_LEVEL_KEY, level);
    }

    public RecordWriter<NullWritable, Object> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.schema == null) {
            throw new IOException("Must provide a schema");
        }
        Configuration conf = context.getConfiguration();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new PigAvroDatumWriter(this.schema));
        if (FileOutputFormat.getCompressOutput((JobContext)context)) {
            int level = conf.getInt(DEFLATE_LEVEL_KEY, 1);
            String codecName = conf.get(OUTPUT_CODEC, DEFLATE_CODEC);
            CodecFactory factory = codecName.equals(DEFLATE_CODEC) ? CodecFactory.deflateCodec((int)level) : CodecFactory.fromString((String)codecName);
            writer.setCodec(factory);
        }
        writer.setSyncInterval(conf.getInt(SYNC_INTERVAL_KEY, Math.max(conf.getInt("io.file.buffer.size", 64000), 64000)));
        Path path = this.getDefaultWorkFile(context, EXT);
        writer.create(this.schema, (OutputStream)path.getFileSystem(conf).create(path));
        return new PigAvroRecordWriter((DataFileWriter<Object>)writer);
    }
}

