/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncResponse;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncResponseFlag;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.util.Strings;

public class AdDirSyncResponseImpl
extends AbstractControl
implements AdDirSyncResponse {
    private Set<AdDirSyncResponseFlag> flags = EnumSet.noneOf(AdDirSyncResponseFlag.class);
    private int maxReturnLength = 0;
    private byte[] cookie;

    public AdDirSyncResponseImpl() {
        super("1.2.840.113556.1.4.841", Boolean.TRUE);
    }

    @Override
    public Set<AdDirSyncResponseFlag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Set<AdDirSyncResponseFlag> flags) {
        this.flags = flags;
    }

    @Override
    public void addFlag(AdDirSyncResponseFlag flag) {
        this.flags.add(flag);
    }

    @Override
    public void removeFlag(AdDirSyncResponseFlag flag) {
        this.flags.remove((Object)flag);
    }

    @Override
    public int getMaxReturnLength() {
        return this.maxReturnLength;
    }

    @Override
    public void setMaxReturnLength(int maxReturnLength) {
        this.maxReturnLength = maxReturnLength;
    }

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        if (cookie != null) {
            this.cookie = new byte[cookie.length];
            System.arraycopy(cookie, 0, this.cookie, 0, cookie.length);
        } else {
            this.cookie = Strings.EMPTY_BYTES;
        }
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 17 + AdDirSyncResponseFlag.getBitmask(this.flags);
        h = h * 17 + this.maxReturnLength;
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdDirSyncResponse)) {
            return false;
        }
        AdDirSyncResponse otherControl = (AdDirSyncResponse)other;
        return super.equals(other) && this.maxReturnLength == otherControl.getMaxReturnLength() && this.flags.equals(otherControl.getFlags()) && Arrays.equals(this.cookie, otherControl.getCookie()) && this.isCritical() == otherControl.isCritical();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    DirSync control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        flags : 0x").append(Integer.toHexString(AdDirSyncResponseFlag.getBitmask(this.flags))).append(' ').append(this.flags.toString()).append("\n");
        sb.append("        maxReturnLength : '").append(this.getMaxReturnLength()).append("'\n");
        sb.append("        cookie            : '").append(Strings.dumpBytes(this.getCookie())).append("'\n");
        return sb.toString();
    }
}

