/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.eventservice.impl.operations;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.ClusterTopologyChangedException;
import com.hazelcast.internal.util.executor.StripedRunnable;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

abstract class AbstractRegistrationOperation
extends Operation
implements AllowedDuringPassiveState,
IdentifiedDataSerializable,
Versioned {
    private int memberListVersion = -1;
    private int orderKey = -1;

    AbstractRegistrationOperation() {
    }

    AbstractRegistrationOperation(int memberListVersion, int orderKey) {
        this.memberListVersion = memberListVersion;
        this.orderKey = orderKey;
    }

    @Override
    public final void run() {
        if (this.orderKey == -1) {
            this.doRun();
        } else {
            EventServiceImpl eventService = (EventServiceImpl)this.getNodeEngine().getEventService();
            eventService.executeEventCallback(new StripedRunnable(){

                @Override
                public void run() {
                    try {
                        AbstractRegistrationOperation.this.doRun();
                    }
                    catch (Throwable e) {
                        AbstractRegistrationOperation.this.logError(e);
                        AbstractRegistrationOperation.this.sendResponse(e);
                    }
                }

                @Override
                public int getKey() {
                    return AbstractRegistrationOperation.this.orderKey;
                }
            }, true);
        }
    }

    private void doRun() {
        this.runInternal();
        this.checkMemberListVersion();
        this.sendResponse(null);
    }

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    protected abstract void runInternal();

    private void checkMemberListVersion() {
        int currentMemberListVersion;
        ClusterService clusterService = this.getNodeEngine().getClusterService();
        if (clusterService.isMaster() && (currentMemberListVersion = clusterService.getMemberListVersion()) != this.memberListVersion) {
            throw new ClusterTopologyChangedException(String.format("Current member list version %d does not match expected %d", currentMemberListVersion, this.memberListVersion));
        }
    }

    @Override
    protected final void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.memberListVersion);
        this.writeInternalImpl(out);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            out.writeInt(this.orderKey);
        }
    }

    protected abstract void writeInternalImpl(ObjectDataOutput var1) throws IOException;

    @Override
    protected final void readInternal(ObjectDataInput in) throws IOException {
        this.memberListVersion = in.readInt();
        this.readInternalImpl(in);
        if (in.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            this.orderKey = in.readInt();
        }
    }

    protected abstract void readInternalImpl(ObjectDataInput var1) throws IOException;

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return throwable instanceof ClusterTopologyChangedException ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }
}

