/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.extra;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.openmeetings.db.dao.room.ExtraMenuDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.entity.room.ExtraMenu;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.web.admin.AdminBaseForm;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.GroupChoiceProvider;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Select2MultiChoice;

public class ExtraForm
extends AdminBaseForm<ExtraMenu> {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer list;
    final Select2MultiChoice<Group> groups = new Select2MultiChoice("groups", (IModel)new CollectionModel(new ArrayList()), (ChoiceProvider)new GroupChoiceProvider());
    @Inject
    private ExtraMenuDao menuDao;
    @Inject
    private GroupDao groupDao;

    public ExtraForm(String id, WebMarkupContainer list, ExtraMenu m) {
        super(id, new CompoundPropertyModel((Object)m));
        this.list = list;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new RequiredTextField("name").setLabel((IModel)new ResourceModel("165"))});
        this.add(new Component[]{new RequiredTextField("link").setLabel((IModel)new ResourceModel("admin.extra.link"))});
        this.add(new Component[]{this.groups.setLabel((IModel)new ResourceModel("126")).setRequired(AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights()))});
        this.add(new Component[]{new TextArea("description").setLabel((IModel)new ResourceModel("lbl.description"))});
    }

    @Override
    protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
        ExtraMenu m = (ExtraMenu)this.getModelObject();
        m.getGroups().clear();
        for (Group g : (Collection)this.groups.getModelObject()) {
            m.getGroups().add(g.getId());
        }
        this.setModelObject(this.menuDao.update(m, WebSession.getUserId()));
        this.setNewVisible(false);
        target.add(new Component[]{this, this.list});
    }

    protected void onModelChanged() {
        super.onModelChanged();
        ExtraMenu m = (ExtraMenu)this.getModelObject();
        this.groups.setModelObject(m == null || m.getGroups() == null || m.getGroups().isEmpty() ? new ArrayList() : this.groupDao.get((Collection)m.getGroups()));
    }

    @Override
    protected void onNewSubmit(AjaxRequestTarget target, Form<?> form) {
        this.setModelObject(new ExtraMenu());
        target.add(new Component[]{this});
    }

    @Override
    protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
        ExtraMenu m = (ExtraMenu)this.getModelObject();
        m = m.getId() != null ? this.menuDao.get(m.getId()) : new ExtraMenu();
        this.setModelObject(m);
        target.add(new Component[]{this});
    }

    @Override
    protected void onDeleteSubmit(AjaxRequestTarget target, Form<?> form) {
        this.menuDao.delete((ExtraMenu)this.getModelObject(), WebSession.getUserId());
        this.setModelObject(new ExtraMenu());
        target.add(new Component[]{this.list, this});
    }
}

