/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.document;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.util.AssertUtils;

public final class DocumentFormat {
    private final String name;
    @SerializedName(value="extensions", alternate={"extension"})
    @JsonAdapter(value=ExtensionsAdapter.class)
    private final List<String> extensions;
    private final String mediaType;
    private final DocumentFamily inputFamily;
    private final Map<String, Object> loadProperties;
    @SerializedName(value="storeProperties", alternate={"storePropertiesByFamily"})
    private final Map<DocumentFamily, Map<String, Object>> storeProperties;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull Builder builder(@NonNull DocumentFormat sourceFormat) {
        return new Builder().from(sourceFormat);
    }

    public static @NonNull DocumentFormat copy(@NonNull DocumentFormat sourceFormat) {
        return DocumentFormat.builder(sourceFormat).unmodifiable(false).build();
    }

    public static @NonNull DocumentFormat unmodifiableCopy(@NonNull DocumentFormat sourceFormat) {
        return DocumentFormat.builder(sourceFormat).unmodifiable(true).build();
    }

    private DocumentFormat() {
        this.name = null;
        this.extensions = null;
        this.mediaType = null;
        this.inputFamily = null;
        this.loadProperties = null;
        this.storeProperties = null;
    }

    private DocumentFormat(String name, Collection<String> extensions, String mediaType, DocumentFamily inputFamily, Map<String, Object> loadProperties, Map<DocumentFamily, Map<String, Object>> storeProperties, boolean unmodifiable) {
        DocumentFormat.checkName(name);
        AssertUtils.notNull(extensions, "extensions must not be null");
        AssertUtils.notBlank(mediaType, "mediaType must not be null nor blank");
        this.name = name;
        this.extensions = new ArrayList<String>(extensions);
        this.mediaType = mediaType;
        this.inputFamily = inputFamily;
        if (loadProperties == null) {
            this.loadProperties = null;
        } else {
            Map<String, Object> map = this.loadProperties = unmodifiable ? Collections.unmodifiableMap(new HashMap<String, Object>(loadProperties)) : new HashMap<String, Object>(loadProperties);
        }
        if (storeProperties == null) {
            this.storeProperties = null;
        } else {
            EnumMap familyMap = new EnumMap(DocumentFamily.class);
            storeProperties.forEach((family, props) -> {
                Map cfr_ignored_0 = familyMap.put((DocumentFamily)((Object)family), unmodifiable ? Collections.unmodifiableMap(new HashMap(props)) : new HashMap(props));
            });
            this.storeProperties = unmodifiable ? Collections.unmodifiableMap(familyMap) : familyMap;
        }
    }

    public @NonNull String getExtension() {
        return this.extensions.get(0);
    }

    public @NonNull List<@NonNull String> getExtensions() {
        return this.extensions;
    }

    public @Nullable DocumentFamily getInputFamily() {
        return this.inputFamily;
    }

    public @Nullable Map<@NonNull String, @NonNull Object> getLoadProperties() {
        return this.loadProperties;
    }

    public @NonNull String getMediaType() {
        return this.mediaType;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @Nullable Map<@NonNull DocumentFamily, @NonNull Map<@NonNull String, @NonNull Object>> getStoreProperties() {
        return this.storeProperties;
    }

    public @Nullable Map<@NonNull String, @NonNull Object> getStoreProperties(@NonNull DocumentFamily family) {
        return this.storeProperties == null ? null : this.storeProperties.get((Object)family);
    }

    public @NonNull String toString() {
        return this.getClass().getSimpleName() + "{name=\"" + this.name + "\", extensions=" + this.extensions + ", mediaType=\"" + this.mediaType + "\", inputFamily=" + (Object)((Object)this.inputFamily) + ", loadProperties=" + this.loadProperties + ", storeProperties=" + this.storeProperties + '}';
    }

    private static void checkName(String name) {
        AssertUtils.notBlank(name, "name must not be null nor blank");
    }

    public static final class Builder {
        private String name;
        private Set<String> extensions;
        private String mediaType;
        private DocumentFamily inputFamily;
        private Map<String, Object> loadProperties;
        private Map<DocumentFamily, Map<String, Object>> storeProperties;
        private boolean unmodifiable = true;

        private Builder() {
        }

        public @NonNull DocumentFormat build() {
            return new DocumentFormat(this.name, this.extensions, this.mediaType, this.inputFamily, this.loadProperties, this.storeProperties, this.unmodifiable);
        }

        public @NonNull Builder from(@NonNull DocumentFormat sourceFormat) {
            AssertUtils.notNull(sourceFormat, "sourceFormat must not be null");
            this.name = sourceFormat.getName();
            this.extensions = new LinkedHashSet<String>(sourceFormat.getExtensions());
            this.mediaType = sourceFormat.getMediaType();
            this.inputFamily = sourceFormat.getInputFamily();
            HashMap<String, Object> hashMap = this.loadProperties = sourceFormat.getLoadProperties() == null ? null : new HashMap<String, Object>(sourceFormat.getLoadProperties());
            if (sourceFormat.getStoreProperties() != null) {
                this.storeProperties = new EnumMap<DocumentFamily, Map<String, Object>>(DocumentFamily.class);
                sourceFormat.getStoreProperties().forEach((family, propMap) -> {
                    Map cfr_ignored_0 = this.storeProperties.put((DocumentFamily)((Object)family), new HashMap(propMap));
                });
            }
            return this;
        }

        public @NonNull Builder extension(@NonNull String extension) {
            AssertUtils.notBlank(extension, "extension must not be null nor blank");
            if (this.extensions == null) {
                this.extensions = new LinkedHashSet<String>();
            }
            this.extensions.add(extension);
            return this;
        }

        public @NonNull Builder inputFamily(@Nullable DocumentFamily inputFamily) {
            this.inputFamily = inputFamily;
            return this;
        }

        public @NonNull Builder loadProperty(@NonNull String name, @Nullable Object value) {
            DocumentFormat.checkName(name);
            if (value == null) {
                if (this.loadProperties != null) {
                    this.loadProperties.remove(name);
                    if (this.loadProperties.isEmpty()) {
                        this.loadProperties = null;
                    }
                }
            } else {
                if (this.loadProperties == null) {
                    this.loadProperties = new HashMap<String, Object>();
                }
                this.loadProperties.put(name, value);
            }
            return this;
        }

        public @NonNull Builder loadFilterName(@Nullable String value) {
            return this.loadProperty("FilterName", value);
        }

        public @NonNull Builder loadFilterOptions(@Nullable String value) {
            return this.loadProperty("FilterOptions", value);
        }

        public @NonNull Builder mediaType(@NonNull String mediaType) {
            AssertUtils.notBlank(mediaType, "mediaType must not be null nor blank");
            this.mediaType = mediaType;
            return this;
        }

        public @NonNull Builder name(@NonNull String name) {
            DocumentFormat.checkName(name);
            this.name = name;
            return this;
        }

        public @NonNull Builder unmodifiable(boolean unmodifiable) {
            this.unmodifiable = unmodifiable;
            return this;
        }

        public @NonNull Builder storeProperty(@NonNull DocumentFamily documentFamily, @NonNull String name, @Nullable Object value) {
            AssertUtils.notNull((Object)documentFamily, "documentFamily must not be null");
            DocumentFormat.checkName(name);
            if (value == null) {
                return this.removeStoreProperty(documentFamily, name);
            }
            if (this.storeProperties == null) {
                this.storeProperties = new EnumMap<DocumentFamily, Map<String, Object>>(DocumentFamily.class);
            }
            this.storeProperties.computeIfAbsent(documentFamily, key -> new HashMap()).put(name, value);
            return this;
        }

        private Builder removeStoreProperty(DocumentFamily documentFamily, String name) {
            Map<String, Object> props;
            if (this.storeProperties != null && (props = this.storeProperties.get((Object)documentFamily)) != null) {
                props.remove(name);
                if (props.isEmpty()) {
                    this.storeProperties.remove((Object)documentFamily);
                }
                if (this.storeProperties.isEmpty()) {
                    this.storeProperties = null;
                }
            }
            return this;
        }

        public @NonNull Builder storeFilterName(@NonNull DocumentFamily documentFamily, @Nullable String value) {
            return this.storeProperty(documentFamily, "FilterName", value);
        }

        public @NonNull Builder storeFilterOptions(@NonNull DocumentFamily documentFamily, @Nullable String value) {
            return this.storeProperty(documentFamily, "FilterOptions", value);
        }
    }

    static class DocumentFormatInstanceCreator
    implements InstanceCreator<DocumentFormat> {
        DocumentFormatInstanceCreator() {
        }

        public DocumentFormat createInstance(Type type) {
            return new DocumentFormat();
        }
    }

    private static class ExtensionsAdapter
    implements JsonDeserializer<List<String>> {
        private ExtensionsAdapter() {
        }

        public List<String> deserialize(JsonElement json, Type type, JsonDeserializationContext cxt) {
            if (json.isJsonArray()) {
                Type listType = new TypeToken<List<String>>(){}.getType();
                return (List)cxt.deserialize(json, listType);
            }
            return Stream.of(json.getAsString()).collect(Collectors.toList());
        }
    }
}

