/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice.util;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import jakarta.ws.rs.ext.ParamConverter;
import java.util.Date;
import org.apache.openmeetings.db.dto.calendar.AppointmentDTO;
import org.apache.openmeetings.db.dto.calendar.MeetingMemberDTO;
import org.apache.openmeetings.db.dto.room.RoomDTO;
import org.apache.openmeetings.db.dto.user.UserDTO;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.util.DtoHelper;
import org.apache.openmeetings.util.CalendarPatterns;
import org.apache.openmeetings.webservice.util.CalendarParamConverter;
import org.apache.openmeetings.webservice.util.DateParamConverter;

public class AppointmentParamConverter
implements ParamConverter<AppointmentDTO> {
    public static final String ROOT = "appointmentDTO";

    public AppointmentDTO fromString(String val) {
        JSONObject o = new JSONObject(val);
        if (o.has(ROOT)) {
            o = o.getJSONObject(ROOT);
        }
        AppointmentDTO a = new AppointmentDTO();
        a.setId(DtoHelper.optLong((JSONObject)o, (String)"id"));
        a.setTitle(o.optString("title"));
        a.setLocation(o.optString("location"));
        a.setOwner(UserDTO.get((JSONObject)o.optJSONObject("owner")));
        String tzId = a.getOwner() == null ? null : a.getOwner().getTimeZoneId();
        a.setStart(CalendarParamConverter.get(o.optString("start"), tzId));
        a.setEnd(CalendarParamConverter.get(o.optString("end"), tzId));
        a.setDescription(o.optString("description"));
        a.setInserted(DateParamConverter.get(o.optString("inserted")));
        a.setUpdated(DateParamConverter.get(o.optString("updated")));
        a.setDeleted(o.optBoolean("deleted"));
        a.setReminder((Appointment.Reminder)DtoHelper.optEnum(Appointment.Reminder.class, (JSONObject)o, (String)"reminder"));
        a.setRoom(RoomDTO.get((JSONObject)o.optJSONObject("room")));
        a.setIcalId(o.optString("icalId"));
        JSONArray mm = o.optJSONArray("meetingMembers");
        if (mm != null) {
            for (int i = 0; i < mm.length(); ++i) {
                a.getMeetingMembers().add(MeetingMemberDTO.get((JSONObject)mm.getJSONObject(i)));
            }
        }
        a.setLanguageId(Long.valueOf(o.optLong("languageId")));
        a.setPassword(o.optString("password"));
        a.setPasswordProtected(o.optBoolean("passwordProtected"));
        a.setConnectedEvent(o.optBoolean("connectedEvent"));
        a.setReminderEmailSend(o.optBoolean("reminderEmailSend"));
        return a;
    }

    public static JSONObject json(AppointmentDTO val) {
        Date i = val.getInserted();
        Date u = val.getUpdated();
        return new JSONObject((Object)val).put("start", (Object)CalendarPatterns.ISO8601_FULL_FORMAT.format(val.getStart())).put("end", (Object)CalendarPatterns.ISO8601_FULL_FORMAT.format(val.getEnd())).put("inserted", i == null ? null : CalendarPatterns.ISO8601_FULL_FORMAT.format(i)).put("updated", u == null ? null : CalendarPatterns.ISO8601_FULL_FORMAT.format(u));
    }

    public String toString(AppointmentDTO val) {
        return AppointmentParamConverter.json(val).toString();
    }
}

