/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav.handler;

import com.github.caldav4j.methods.HttpCalDAVReportMethod;
import com.github.caldav4j.model.request.CalDAVReportRequest;
import com.github.caldav4j.model.request.CalendarData;
import com.github.caldav4j.model.request.CalendarMultiget;
import com.github.caldav4j.model.request.CompFilter;
import com.github.caldav4j.model.response.CalendarDataProperty;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.service.calendar.caldav.IcalUtils;
import org.apache.openmeetings.service.calendar.caldav.handler.AbstractCalendarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultigetHandler
extends AbstractCalendarHandler {
    private static final Logger log = LoggerFactory.getLogger(MultigetHandler.class);
    private CalendarMultiget query;
    private boolean isMultigetDisabled = false;
    private boolean onlyEtag = false;

    public MultigetHandler(List<String> hrefs, boolean onlyEtag, String path, OmCalendar calendar, HttpClient client, HttpClientContext context, AppointmentDao appointmentDao, IcalUtils utils) {
        super(path, calendar, client, context, appointmentDao, utils);
        this.onlyEtag = onlyEtag;
        if (hrefs == null || hrefs.isEmpty() || calendar.getSyncType() == OmCalendar.SyncType.NONE) {
            this.isMultigetDisabled = true;
        } else {
            DavPropertyNameSet properties = new DavPropertyNameSet();
            properties.add(DavPropertyName.GETETAG);
            CalendarData calendarData = null;
            if (!onlyEtag) {
                calendarData = new CalendarData();
            }
            CompFilter vcalendar = new CompFilter("VCALENDAR");
            vcalendar.addCompFilter(new CompFilter("VEVENT"));
            this.query = new CalendarMultiget(properties, calendarData, false, false);
            this.query.setHrefs(hrefs);
        }
    }

    public MultigetHandler(List<String> hrefs, String path, OmCalendar calendar, HttpClient client, HttpClientContext context, AppointmentDao appointmentDao, IcalUtils utils) {
        this(hrefs, false, path, calendar, client, context, appointmentDao, utils);
    }

    @Override
    BaseDavRequest internalSyncItems() throws IOException, DavException {
        Long ownerId = this.calendar.getOwner().getId();
        if (!this.isMultigetDisabled) {
            HttpCalDAVReportMethod method = new HttpCalDAVReportMethod(this.path, (CalDAVReportRequest)this.query, 1);
            HttpResponse httpResponse = this.client.execute((HttpUriRequest)method, (HttpContext)this.context);
            if (method.succeeded(httpResponse)) {
                Map<String, Appointment> map = MultigetHandler.listToMap(this.appointmentDao.getbyCalendar(this.calendar.getId()));
                for (MultiStatusResponse response : method.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                    if (response.getStatus()[0].getStatusCode() != 200) continue;
                    Appointment a = map.get(response.getHref());
                    if (a != null) {
                        String origetag = a.getEtag();
                        String currentetag = CalendarDataProperty.getEtagfromResponse((MultiStatusResponse)response);
                        if (currentetag.equals(origetag)) continue;
                        if (this.onlyEtag) {
                            a.setEtag(currentetag);
                        } else {
                            Calendar calendar = CalendarDataProperty.getCalendarfromResponse((MultiStatusResponse)response);
                            a = this.utils.parseCalendartoAppointment(a, calendar, currentetag);
                        }
                        this.appointmentDao.update(a, ownerId);
                        continue;
                    }
                    if (this.onlyEtag) continue;
                    String etag = CalendarDataProperty.getEtagfromResponse((MultiStatusResponse)response);
                    Calendar ical = CalendarDataProperty.getCalendarfromResponse((MultiStatusResponse)response);
                    Appointment appointments = this.utils.parseCalendartoAppointment(ical, response.getHref(), etag, this.calendar);
                    this.appointmentDao.update(appointments, ownerId);
                }
            } else {
                log.error("Report Method return Status: {} for calId {}", (Object)httpResponse.getStatusLine().getStatusCode(), (Object)this.calendar.getId());
            }
            return method;
        }
        return null;
    }

    @Override
    public boolean updateItem(Appointment appointment) {
        return false;
    }

    @Override
    public boolean deleteItem(Appointment appointment) {
        return false;
    }
}

