/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.exchange;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.exchange.Exchange;
import org.apache.nutch.exchange.ExchangeConfig;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Exchanges {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, ExchangeConfigRelation> exchanges;
    private ExchangeConfig defaultExchangeConfig;
    private boolean availableExchanges = true;

    public Exchanges(Configuration conf) {
        try {
            ExchangeConfig[] exchangeConfigs;
            ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(Exchange.X_POINT_ID);
            if (point == null) {
                throw new RuntimeException(Exchange.X_POINT_ID + " not found.");
            }
            HashMap<String, Extension> extensionMap = new HashMap<String, Extension>();
            for (Extension extension : point.getExtensions()) {
                extensionMap.putIfAbsent(extension.getClazz(), extension);
            }
            this.exchanges = new HashMap<String, ExchangeConfigRelation>();
            for (ExchangeConfig exchangeConfig : exchangeConfigs = this.loadConfigurations(conf)) {
                String clazz = exchangeConfig.getClazz();
                if (!extensionMap.containsKey(clazz)) continue;
                ExchangeConfigRelation exchangeConfigRelation = new ExchangeConfigRelation((Exchange)((Extension)extensionMap.get(clazz)).getExtensionInstance(), exchangeConfig);
                this.exchanges.put(exchangeConfig.getId(), exchangeConfigRelation);
            }
            if (this.exchanges.isEmpty() && this.defaultExchangeConfig == null) {
                this.availableExchanges = false;
                LOG.warn("No exchange was configured. The documents will be routed to all index writers.");
            }
        }
        catch (PluginRuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean areAvailableExchanges() {
        return this.availableExchanges;
    }

    private ExchangeConfig[] loadConfigurations(Configuration conf) {
        String filename = conf.get("exchanges.exchanges.file", "exchanges.xml");
        InputSource inputSource = new InputSource(conf.getConfResourceAsInputStream(filename));
        LinkedList<ExchangeConfig> configList = new LinkedList<ExchangeConfig>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Element rootElement = builder.parse(inputSource).getDocumentElement();
            NodeList exchangeList = rootElement.getElementsByTagName("exchange");
            for (int i = 0; i < exchangeList.getLength(); ++i) {
                Element element = (Element)exchangeList.item(i);
                ExchangeConfig exchangeConfig = ExchangeConfig.getInstance(element);
                if ("default".equals(exchangeConfig.getClazz())) {
                    this.defaultExchangeConfig = exchangeConfig;
                    continue;
                }
                configList.add(exchangeConfig);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(e.toString());
        }
        return configList.toArray(new ExchangeConfig[0]);
    }

    public void open() {
        this.exchanges.forEach((id, value) -> value.exchange.open(value.config.getParameters()));
    }

    public String[] indexWriters(NutchDocument nutchDocument) {
        HashSet writersIDs = new HashSet();
        this.exchanges.forEach((id, value) -> {
            if (value.exchange.match(nutchDocument)) {
                writersIDs.addAll(Arrays.asList(value.config.getWritersIDs()));
            }
        });
        if (this.defaultExchangeConfig != null && writersIDs.isEmpty()) {
            return this.defaultExchangeConfig.getWritersIDs();
        }
        return writersIDs.toArray(new String[0]);
    }

    private class ExchangeConfigRelation {
        private final Exchange exchange;
        private final ExchangeConfig config;

        ExchangeConfigRelation(Exchange exchange, ExchangeConfig config) {
            this.exchange = exchange;
            this.config = config;
        }
    }
}

