/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.coordinator.group.consumer.VersionedMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;

public class ClientAssignor {
    private final String name;
    private final byte reason;
    private final short minimumVersion;
    private final short maximumVersion;
    private final VersionedMetadata metadata;

    public ClientAssignor(String name, byte reason, short minimumVersion, short maximumVersion, VersionedMetadata metadata) {
        this.name = Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Assignor name cannot be empty.");
        }
        this.reason = reason;
        this.minimumVersion = minimumVersion;
        if (minimumVersion < -1) {
            throw new IllegalArgumentException("Assignor minimum version must be greater than -1.");
        }
        this.maximumVersion = maximumVersion;
        if (maximumVersion < 0) {
            throw new IllegalArgumentException("Assignor maximum version must be greater than or equals to 0.");
        }
        if (maximumVersion < minimumVersion) {
            throw new IllegalArgumentException("Assignor maximum version must be greater than or equals to the minimum version.");
        }
        this.metadata = Objects.requireNonNull(metadata);
    }

    public String name() {
        return this.name;
    }

    public byte reason() {
        return this.reason;
    }

    public short minimumVersion() {
        return this.minimumVersion;
    }

    public short maximumVersion() {
        return this.maximumVersion;
    }

    public VersionedMetadata metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientAssignor that = (ClientAssignor)o;
        if (this.reason != that.reason) {
            return false;
        }
        if (this.minimumVersion != that.minimumVersion) {
            return false;
        }
        if (this.maximumVersion != that.maximumVersion) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.reason;
        result = 31 * result + this.minimumVersion;
        result = 31 * result + this.maximumVersion;
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public String toString() {
        return "ClientAssignor(name=" + this.name + ", reason=" + this.reason + ", minimumVersion=" + this.minimumVersion + ", maximumVersion=" + this.maximumVersion + ", metadata=" + this.metadata + ')';
    }

    public static ClientAssignor fromRecord(ConsumerGroupMemberMetadataValue.Assignor record) {
        return new ClientAssignor(record.name(), record.reason(), record.minimumVersion(), record.maximumVersion(), new VersionedMetadata(record.version(), ByteBuffer.wrap(record.metadata())));
    }
}

