/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRunnable;
import org.opensearch.common.Randomness;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchRejectedExecutionException;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public abstract class RetryableAction<Response> {
    private final Logger logger;
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final ThreadPool threadPool;
    private final long initialDelayMillis;
    private final long timeoutMillis;
    private final long startMillis;
    private final ActionListener<Response> finalListener;
    private final String executor;
    private volatile Scheduler.ScheduledCancellable retryTask;

    public RetryableAction(Logger logger, ThreadPool threadPool, TimeValue initialDelay, TimeValue timeoutValue, ActionListener<Response> listener) {
        this(logger, threadPool, initialDelay, timeoutValue, listener, "same");
    }

    public RetryableAction(Logger logger, ThreadPool threadPool, TimeValue initialDelay, TimeValue timeoutValue, ActionListener<Response> listener, String executor) {
        this.logger = logger;
        this.threadPool = threadPool;
        this.initialDelayMillis = initialDelay.getMillis();
        if (this.initialDelayMillis < 1L) {
            throw new IllegalArgumentException("Initial delay was less than 1 millisecond: " + initialDelay);
        }
        this.timeoutMillis = timeoutValue.getMillis();
        this.startMillis = threadPool.relativeTimeInMillis();
        this.finalListener = listener;
        this.executor = executor;
    }

    public void run() {
        RetryingListener retryingListener = new RetryingListener(this.initialDelayMillis, null);
        Runnable runnable = this.createRunnable(retryingListener);
        this.threadPool.executor(this.executor).execute(runnable);
    }

    public void cancel(Exception e) {
        if (this.isDone.compareAndSet(false, true)) {
            Scheduler.ScheduledCancellable localRetryTask = this.retryTask;
            if (localRetryTask != null) {
                localRetryTask.cancel();
            }
            this.onFinished();
            this.finalListener.onFailure(e);
        }
    }

    private Runnable createRunnable(RetryingListener retryingListener) {
        return new ActionRunnable<Response>(retryingListener){

            @Override
            protected void doRun() {
                RetryableAction.this.retryTask = null;
                if (!RetryableAction.this.isDone.get()) {
                    RetryableAction.this.tryAction(this.listener);
                }
            }

            @Override
            public void onRejection(Exception e) {
                RetryableAction.this.retryTask = null;
                this.onFailure(e);
            }
        };
    }

    public abstract void tryAction(ActionListener<Response> var1);

    public abstract boolean shouldRetry(Exception var1);

    public void onFinished() {
    }

    private class RetryingListener
    implements ActionListener<Response> {
        private static final int MAX_EXCEPTIONS = 4;
        private final long delayMillisBound;
        private ArrayDeque<Exception> caughtExceptions;

        private RetryingListener(long delayMillisBound, ArrayDeque<Exception> caughtExceptions) {
            this.delayMillisBound = delayMillisBound;
            this.caughtExceptions = caughtExceptions;
        }

        @Override
        public void onResponse(Response response) {
            if (RetryableAction.this.isDone.compareAndSet(false, true)) {
                RetryableAction.this.onFinished();
                RetryableAction.this.finalListener.onResponse(response);
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (RetryableAction.this.shouldRetry(e)) {
                long elapsedMillis = RetryableAction.this.threadPool.relativeTimeInMillis() - RetryableAction.this.startMillis;
                if (elapsedMillis >= RetryableAction.this.timeoutMillis) {
                    RetryableAction.this.logger.debug(() -> new ParameterizedMessage("retryable action timed out after {}", (Object)TimeValue.timeValueMillis((long)elapsedMillis)), (Throwable)e);
                    this.onFinalFailure(e);
                } else {
                    this.addException(e);
                    long nextDelayMillisBound = Math.min(this.delayMillisBound * 2L, Integer.MAX_VALUE);
                    RetryingListener retryingListener = new RetryingListener(nextDelayMillisBound, this.caughtExceptions);
                    Runnable runnable = RetryableAction.this.createRunnable(retryingListener);
                    long delayMillis = Randomness.get().nextInt(Math.toIntExact(this.delayMillisBound)) + 1;
                    if (!RetryableAction.this.isDone.get()) {
                        TimeValue delay = TimeValue.timeValueMillis((long)delayMillis);
                        RetryableAction.this.logger.debug(() -> new ParameterizedMessage("retrying action that failed in {}", (Object)delay), (Throwable)e);
                        try {
                            RetryableAction.this.retryTask = RetryableAction.this.threadPool.schedule(runnable, delay, RetryableAction.this.executor);
                        }
                        catch (OpenSearchRejectedExecutionException ree) {
                            this.onFinalFailure(ree);
                        }
                    }
                }
            } else {
                this.onFinalFailure(e);
            }
        }

        private void onFinalFailure(Exception e) {
            this.addException(e);
            if (RetryableAction.this.isDone.compareAndSet(false, true)) {
                RetryableAction.this.onFinished();
                RetryableAction.this.finalListener.onFailure(this.buildFinalException());
            }
        }

        private Exception buildFinalException() {
            Exception suppressed;
            Exception topLevel = this.caughtExceptions.removeFirst();
            while ((suppressed = this.caughtExceptions.pollFirst()) != null) {
                topLevel.addSuppressed(suppressed);
            }
            return topLevel;
        }

        private void addException(Exception e) {
            if (this.caughtExceptions != null) {
                if (this.caughtExceptions.size() == 4) {
                    this.caughtExceptions.removeLast();
                }
            } else {
                this.caughtExceptions = new ArrayDeque(4);
            }
            this.caughtExceptions.addFirst(e);
        }
    }
}

