/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.overlay;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v85.dom.model.NodeId;
import org.openqa.selenium.devtools.v85.dom.model.Quad;
import org.openqa.selenium.devtools.v85.dom.model.RGBA;
import org.openqa.selenium.devtools.v85.overlay.model.ColorFormat;
import org.openqa.selenium.devtools.v85.overlay.model.HighlightConfig;
import org.openqa.selenium.devtools.v85.overlay.model.HingeConfig;
import org.openqa.selenium.devtools.v85.overlay.model.InspectMode;
import org.openqa.selenium.devtools.v85.page.model.FrameId;
import org.openqa.selenium.devtools.v85.page.model.Viewport;
import org.openqa.selenium.devtools.v85.runtime.model.RemoteObjectId;

@Beta
public class Overlay {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Overlay.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Overlay.enable", Map.copyOf(params));
    }

    public static Command<Map<String, Object>> getHighlightObjectForTest(NodeId nodeId, Optional<Boolean> includeDistance, Optional<Boolean> includeStyle, Optional<ColorFormat> colorFormat, Optional<Boolean> showAccessibilityInfo) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        includeDistance.ifPresent(p -> params.put("includeDistance", (NodeId)p));
        includeStyle.ifPresent(p -> params.put("includeStyle", (NodeId)p));
        colorFormat.ifPresent(p -> params.put("colorFormat", (NodeId)p));
        showAccessibilityInfo.ifPresent(p -> params.put("showAccessibilityInfo", (NodeId)p));
        return new Command("Overlay.getHighlightObjectForTest", Map.copyOf(params), ConverterFunctions.map((String)"highlight", Map.class));
    }

    public static Command<Void> hideHighlight() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Overlay.hideHighlight", Map.copyOf(params));
    }

    public static Command<Void> highlightFrame(FrameId frameId, Optional<RGBA> contentColor, Optional<RGBA> contentOutlineColor) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        contentColor.ifPresent(p -> params.put("contentColor", (FrameId)p));
        contentOutlineColor.ifPresent(p -> params.put("contentOutlineColor", (FrameId)p));
        return new Command("Overlay.highlightFrame", Map.copyOf(params));
    }

    public static Command<Void> highlightNode(HighlightConfig highlightConfig, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> selector) {
        Objects.requireNonNull(highlightConfig, "highlightConfig is required");
        LinkedHashMap<String, HighlightConfig> params = new LinkedHashMap<String, HighlightConfig>();
        params.put("highlightConfig", highlightConfig);
        nodeId.ifPresent(p -> params.put("nodeId", (HighlightConfig)p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", (HighlightConfig)p));
        objectId.ifPresent(p -> params.put("objectId", (HighlightConfig)p));
        selector.ifPresent(p -> params.put("selector", (HighlightConfig)p));
        return new Command("Overlay.highlightNode", Map.copyOf(params));
    }

    public static Command<Void> highlightQuad(Quad quad, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(quad, "quad is required");
        LinkedHashMap<String, Quad> params = new LinkedHashMap<String, Quad>();
        params.put("quad", quad);
        color.ifPresent(p -> params.put("color", (Quad)p));
        outlineColor.ifPresent(p -> params.put("outlineColor", (Quad)p));
        return new Command("Overlay.highlightQuad", Map.copyOf(params));
    }

    public static Command<Void> highlightRect(Integer x, Integer y, Integer width, Integer height, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("x", x);
        params.put("y", y);
        params.put("width", width);
        params.put("height", height);
        color.ifPresent(p -> params.put("color", (Integer)p));
        outlineColor.ifPresent(p -> params.put("outlineColor", (Integer)p));
        return new Command("Overlay.highlightRect", Map.copyOf(params));
    }

    public static Command<Void> setInspectMode(InspectMode mode, Optional<HighlightConfig> highlightConfig) {
        Objects.requireNonNull(mode, "mode is required");
        LinkedHashMap<String, InspectMode> params = new LinkedHashMap<String, InspectMode>();
        params.put("mode", mode);
        highlightConfig.ifPresent(p -> params.put("highlightConfig", (InspectMode)((Object)p)));
        return new Command("Overlay.setInspectMode", Map.copyOf(params));
    }

    public static Command<Void> setShowAdHighlights(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command("Overlay.setShowAdHighlights", Map.copyOf(params));
    }

    public static Command<Void> setPausedInDebuggerMessage(Optional<String> message) {
        LinkedHashMap params = new LinkedHashMap();
        message.ifPresent(p -> params.put("message", p));
        return new Command("Overlay.setPausedInDebuggerMessage", Map.copyOf(params));
    }

    public static Command<Void> setShowDebugBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command("Overlay.setShowDebugBorders", Map.copyOf(params));
    }

    public static Command<Void> setShowFPSCounter(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command("Overlay.setShowFPSCounter", Map.copyOf(params));
    }

    public static Command<Void> setShowPaintRects(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("result", result);
        return new Command("Overlay.setShowPaintRects", Map.copyOf(params));
    }

    public static Command<Void> setShowLayoutShiftRegions(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("result", result);
        return new Command("Overlay.setShowLayoutShiftRegions", Map.copyOf(params));
    }

    public static Command<Void> setShowScrollBottleneckRects(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command("Overlay.setShowScrollBottleneckRects", Map.copyOf(params));
    }

    public static Command<Void> setShowHitTestBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command("Overlay.setShowHitTestBorders", Map.copyOf(params));
    }

    public static Command<Void> setShowViewportSizeOnResize(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command("Overlay.setShowViewportSizeOnResize", Map.copyOf(params));
    }

    public static Command<Void> setShowHinge(Optional<HingeConfig> hingeConfig) {
        LinkedHashMap params = new LinkedHashMap();
        hingeConfig.ifPresent(p -> params.put("hingeConfig", p));
        return new Command("Overlay.setShowHinge", Map.copyOf(params));
    }

    public static Event<BackendNodeId> inspectNodeRequested() {
        return new Event("Overlay.inspectNodeRequested", ConverterFunctions.map((String)"backendNodeId", BackendNodeId.class));
    }

    public static Event<NodeId> nodeHighlightRequested() {
        return new Event("Overlay.nodeHighlightRequested", ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Event<Viewport> screenshotRequested() {
        return new Event("Overlay.screenshotRequested", ConverterFunctions.map((String)"viewport", Viewport.class));
    }

    public static Event<Void> inspectModeCanceled() {
        return new Event("Overlay.inspectModeCanceled", ConverterFunctions.empty());
    }
}

