/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SeekableLineReaderFactory;
import org.archive.util.binsearch.impl.RandomAccessFileSeekableLineReader;

public class RandomAccessFileSeekableLineReaderFactory
implements SeekableLineReaderFactory {
    private File file;
    private int blockSize = 8192;

    public RandomAccessFileSeekableLineReaderFactory(File file) {
        this.file = file;
    }

    public RandomAccessFileSeekableLineReaderFactory(File file, int blockSize) {
        this.file = file;
        this.blockSize = blockSize;
    }

    @Override
    public SeekableLineReader get() throws IOException {
        return new RandomAccessFileSeekableLineReader(new RandomAccessFile(this.file, "r"), this.blockSize);
    }

    @Override
    public void close() throws IOException {
        this.file = null;
    }

    @Override
    public long getModTime() {
        return this.file.lastModified();
    }

    @Override
    public void reload() throws IOException {
    }
}

