/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import org.archive.io.CharSubSequence;
import org.archive.io.SeekReader;

public class SeekReaderCharSequence
implements CharSequence {
    private final SeekReader reader;
    private final int size;

    public SeekReaderCharSequence(SeekReader reader, int size) {
        this.reader = reader;
        this.size = size;
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        try {
            this.reader.position(index);
            int r = this.reader.read();
            if (r < 0) {
                throw new IllegalStateException("EOF");
            }
            return (char)this.reader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharSubSequence(this, start, end);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.reader.position(0L);
            int ch = this.reader.read();
            while (ch >= 0) {
                sb.append((char)ch);
                ch = this.reader.read();
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

