/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.prefix;

import java.util.List;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;

public class NoPluginFoundForPrefixException
extends Exception {
    public NoPluginFoundForPrefixException(String prefix, List<String> pluginGroups, LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        super("No plugin found for prefix '" + prefix + "' in the current project and in the plugin groups " + String.valueOf(pluginGroups) + " available from the repositories " + NoPluginFoundForPrefixException.format(localRepository, remoteRepositories));
    }

    private static String format(LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        StringBuilder repos = new StringBuilder("[");
        if (localRepository != null) {
            repos.append(localRepository.getId()).append(" (").append(localRepository.getBasedir()).append(")");
        }
        if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
            for (RemoteRepository repository : remoteRepositories) {
                repos.append(", ");
                if (repository == null) continue;
                repos.append(repository.getId()).append(" (").append(repository.getUrl()).append(")");
            }
        }
        repos.append("]");
        return repos.toString();
    }
}

