/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.util;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhasingExecutor
implements Executor,
AutoCloseable {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private static final Logger LOGGER = LoggerFactory.getLogger(PhasingExecutor.class);
    private final ExecutorService executor;
    private final AtomicBoolean shutdownInitiated = new AtomicBoolean(false);
    private final AtomicBoolean inPhase = new AtomicBoolean(false);
    private final AtomicInteger activeTaskCount = new AtomicInteger(0);
    private final AtomicInteger completedTaskCount = new AtomicInteger(0);
    private final int id = ID.incrementAndGet();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition taskCompletionCondition = this.lock.newCondition();

    public PhasingExecutor(ExecutorService executor) {
        this.executor = executor;
        this.log("[{}][general] PhasingExecutor created.");
    }

    @Override
    public void execute(Runnable command) {
        this.activeTaskCount.incrementAndGet();
        this.log("[{}][task] Task submitted. Active tasks: {}", this.activeTaskCount.get());
        this.executor.execute(() -> {
            try {
                this.log("[{}][task] Task executing. Active tasks: {}", this.activeTaskCount.get());
                command.run();
            }
            finally {
                this.lock.lock();
                try {
                    this.completedTaskCount.incrementAndGet();
                    this.activeTaskCount.decrementAndGet();
                    this.log("[{}][task] Task completed. Active tasks: {}", this.activeTaskCount.get());
                    this.taskCompletionCondition.signalAll();
                    if (this.activeTaskCount.get() == 0 && this.shutdownInitiated.get()) {
                        this.log("[{}][task] Last task completed. Initiating executor shutdown.");
                        this.executor.shutdown();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        });
    }

    public AutoCloseable phase() {
        if (this.inPhase.getAndSet(true)) {
            throw new IllegalStateException("Already in a phase");
        }
        int phaseNumber = this.completedTaskCount.get();
        this.log("[{}][phase] Entering phase {}. Active tasks: {}", phaseNumber, this.activeTaskCount.get());
        return () -> {
            try {
                int tasksAtPhaseStart = this.completedTaskCount.get();
                this.log("[{}][phase] Closing phase {}. Waiting for all tasks to complete.", phaseNumber);
                this.lock.lock();
                try {
                    while (this.activeTaskCount.get() > 0 && this.completedTaskCount.get() - tasksAtPhaseStart < this.activeTaskCount.get()) {
                        this.taskCompletionCondition.await(100L, TimeUnit.MILLISECONDS);
                    }
                }
                finally {
                    this.lock.unlock();
                }
                this.log("[{}][phase] Phase {} completed. Total completed tasks: {}", phaseNumber, this.completedTaskCount.get());
            }
            catch (InterruptedException e) {
                this.log("[{}][phase] Phase {} was interrupted.", phaseNumber);
                Thread.currentThread().interrupt();
                throw new RuntimeException("Phase interrupted", e);
            }
            finally {
                this.inPhase.set(false);
            }
        };
    }

    @Override
    public void close() {
        this.log("[{}][close] Closing PhasingExecutor. Active tasks: {}", this.activeTaskCount.get());
        if (this.shutdownInitiated.getAndSet(true)) {
            this.log("[{}][close] Shutdown already initiated. Returning.");
            return;
        }
        this.lock.lock();
        try {
            while (this.activeTaskCount.get() > 0) {
                this.log("[{}][close] Waiting for {} active tasks to complete.", this.activeTaskCount.get());
                this.taskCompletionCondition.await(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            this.log("[{}][close] Interrupted while waiting for tasks to complete.");
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
            this.log("[{}][close] All tasks completed. Shutting down executor.");
            this.executor.shutdown();
        }
        this.log("[{}][close] PhasingExecutor closed. Total completed tasks: {}", this.completedTaskCount.get());
    }

    private void log(String message) {
        LOGGER.debug(message, (Object)this.id);
    }

    private void log(String message, Object o1) {
        LOGGER.debug(message, (Object)this.id, o1);
    }

    private void log(String message, Object o1, Object o2) {
        LOGGER.debug(message, new Object[]{this.id, o1, o2});
    }
}

