/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.internal.xml.XmlNodeStaxBuilder;
import org.apache.maven.project.ExtensionDescriptor;

public class ExtensionDescriptorBuilder {
    public String getExtensionDescriptorLocation() {
        return "META-INF/maven/extension.xml";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtensionDescriptor build(File extensionJar) throws IOException {
        ExtensionDescriptor extensionDescriptor = null;
        if (extensionJar.isFile()) {
            try (JarFile pluginJar = new JarFile(extensionJar, false);){
                ZipEntry pluginDescriptorEntry = pluginJar.getEntry(this.getExtensionDescriptorLocation());
                if (pluginDescriptorEntry == null) return extensionDescriptor;
                try (InputStream is = pluginJar.getInputStream(pluginDescriptorEntry);){
                    extensionDescriptor = this.build(is);
                    return extensionDescriptor;
                }
            }
        }
        File pluginXml = new File(extensionJar, this.getExtensionDescriptorLocation());
        if (!pluginXml.canRead()) return extensionDescriptor;
        try (InputStream is = Files.newInputStream(pluginXml.toPath(), new OpenOption[0]);){
            extensionDescriptor = this.build(is);
            return extensionDescriptor;
        }
    }

    public ExtensionDescriptor build(InputStream is) throws IOException {
        XmlNodeImpl dom;
        ExtensionDescriptor extensionDescriptor = new ExtensionDescriptor();
        try {
            XMLStreamReader reader = XMLInputFactory.newFactory().createXMLStreamReader(is);
            dom = XmlNodeStaxBuilder.build((XMLStreamReader)reader);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage(), e);
        }
        if (!"extension".equals(dom.getName())) {
            throw new IOException("Unexpected root element \"" + dom.getName() + "\", expected \"extension\"");
        }
        extensionDescriptor.setExportedPackages(this.parseStrings(dom.getChild("exportedPackages")));
        extensionDescriptor.setExportedArtifacts(this.parseStrings(dom.getChild("exportedArtifacts")));
        return extensionDescriptor;
    }

    private List<String> parseStrings(XmlNode dom) {
        ArrayList<String> strings = null;
        if (dom != null) {
            strings = new ArrayList<String>();
            for (XmlNode child : dom.getChildren()) {
                String string = child.getValue();
                if (string == null || (string = string.trim()).isEmpty()) continue;
                strings.add(string);
            }
        }
        return strings;
    }
}

