/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.MessageBuilder;

@Experimental
public class DefaultMessageBuilder
implements MessageBuilder {
    private final StringBuilder buffer;

    public DefaultMessageBuilder() {
        this(new StringBuilder());
    }

    public DefaultMessageBuilder(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public MessageBuilder style(String style) {
        return this;
    }

    public MessageBuilder resetStyle() {
        return this;
    }

    public MessageBuilder append(CharSequence cs) {
        this.buffer.append(cs);
        return this;
    }

    public MessageBuilder append(CharSequence cs, int start, int end) {
        this.buffer.append(cs, start, end);
        return this;
    }

    public MessageBuilder append(char c) {
        this.buffer.append(c);
        return this;
    }

    public MessageBuilder setLength(int length) {
        this.buffer.setLength(length);
        return this;
    }

    @Nonnull
    public String build() {
        return this.buffer.toString();
    }

    public String toString() {
        return this.build();
    }
}

