/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;
import java.io.Serializable;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.slf4j.impl.SimpleLogger;

public class MavenSimpleLogger
extends SimpleLogger {
    MavenSimpleLogger(String name) {
        super(name);
    }

    @Override
    protected String renderLevel(int level) {
        switch (level) {
            case 0: {
                return MessageUtils.level().debug("TRACE").toString();
            }
            case 10: {
                return MessageUtils.level().debug("DEBUG").toString();
            }
            case 20: {
                return MessageUtils.level().info("INFO").toString();
            }
            case 30: {
                return MessageUtils.level().warning("WARNING").toString();
            }
        }
        return MessageUtils.level().error("ERROR").toString();
    }

    @Override
    protected void writeThrowable(Throwable t, PrintStream stream) {
        if (t == null) {
            return;
        }
        stream.print(MessageUtils.buffer().failure((Object)t.getClass().getName()));
        if (t.getMessage() != null) {
            stream.print(": ");
            stream.print(MessageUtils.buffer().failure((Object)t.getMessage()));
        }
        stream.println();
        this.printStackTrace(t, stream, "");
    }

    private void printStackTrace(Throwable t, PrintStream stream, String prefix) {
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            stream.print(prefix);
            stream.print("    ");
            stream.print(MessageUtils.buffer().strong((Object)"at"));
            stream.print(" " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName());
            stream.print(MessageUtils.buffer().a((CharSequence)" (").strong((Object)this.getLocation(stackTraceElement)).a((CharSequence)")"));
            stream.println();
        }
        for (Serializable serializable : t.getSuppressed()) {
            this.writeThrowable((Throwable)serializable, stream, "Suppressed", prefix + "    ");
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            this.writeThrowable(cause, stream, "Caused by", prefix);
        }
    }

    private void writeThrowable(Throwable t, PrintStream stream, String caption, String prefix) {
        stream.print(MessageUtils.buffer().a((CharSequence)prefix).strong((Object)caption).a((CharSequence)": ").a((CharSequence)t.getClass().getName()));
        if (t.getMessage() != null) {
            stream.print(": ");
            stream.print(MessageUtils.buffer().failure((Object)t.getMessage()));
        }
        stream.println();
        this.printStackTrace(t, stream, prefix);
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return String.format("%s:%s", e.getFileName(), e.getLineNumber());
        }
        return e.getFileName();
    }
}

