/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.util.SuppressForbidden;

public class WaitTask
extends PerfTask {
    private double waitTimeSec;

    public WaitTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setParams(String params) {
        int multiplier;
        super.setParams(params);
        if (params != null) {
            if (params.endsWith("s")) {
                multiplier = 1;
                params = params.substring(0, params.length() - 1);
            } else if (params.endsWith("m")) {
                multiplier = 60;
                params = params.substring(0, params.length() - 1);
            } else if (params.endsWith("h")) {
                multiplier = 3600;
                params = params.substring(0, params.length() - 1);
            } else {
                multiplier = 1;
            }
        } else {
            throw new IllegalArgumentException("you must specify the wait time, eg: 10.0s, 4.5m, 2h");
        }
        this.waitTimeSec = Double.parseDouble(params) * (double)multiplier;
    }

    @Override
    @SuppressForbidden(reason="Thread sleep")
    public int doLogic() throws Exception {
        Thread.sleep((long)(1000.0 * this.waitTimeSec));
        return 0;
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

