/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.serializer.SerializeException;

public class SerializerWriter
extends Writer {
    protected final Writer out;
    protected final boolean useWhitespace;
    protected final int maxIndent;
    protected final boolean trimStrings;
    protected final char quoteChar;
    protected final UriResolver uriResolver;

    public SerializerWriter(SerializerWriter w) {
        this.out = w.out;
        this.useWhitespace = w.useWhitespace;
        this.maxIndent = w.maxIndent;
        this.trimStrings = w.trimStrings;
        this.quoteChar = w.quoteChar;
        this.uriResolver = w.uriResolver;
    }

    public SerializerWriter(Writer out, boolean useWhitespace, int maxIndent, boolean trimStrings, char quoteChar, UriResolver uriResolver) {
        this.out = out;
        this.useWhitespace = useWhitespace;
        this.maxIndent = maxIndent;
        this.trimStrings = trimStrings;
        this.quoteChar = quoteChar;
        this.uriResolver = uriResolver;
    }

    @Override
    public SerializerWriter append(char c) {
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    public SerializerWriter append(char[] value) {
        for (char c : value) {
            this.w(c);
        }
        return this;
    }

    public SerializerWriter append(int indent, char value) {
        return this.i(indent).w(value);
    }

    public SerializerWriter append(int indent, String value) {
        return this.append(indent, false, value);
    }

    public SerializerWriter append(Object value) {
        this.w(value == null ? null : value.toString());
        return this;
    }

    public SerializerWriter append(String value) {
        if (Utils.nn((Object)value)) {
            this.w(value);
        }
        return this;
    }

    public SerializerWriter appendIf(boolean flag, char value) {
        if (flag) {
            this.w(value);
        }
        return this;
    }

    public SerializerWriter appendIf(boolean flag, String value) {
        if (flag) {
            this.w(value);
        }
        return this;
    }

    public SerializerWriter appendln(int indent, String value) {
        return this.append(indent, true, value);
    }

    public SerializerWriter appendln(String value) {
        return this.append(0, true, value);
    }

    public SerializerWriter appendUri(Object value) {
        this.uriResolver.append(this, value);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public SerializerWriter cr(int depth) {
        if (this.useWhitespace && depth <= this.maxIndent) {
            return this.nl(depth).i(depth);
        }
        return this;
    }

    public SerializerWriter cre(int depth) {
        if (this.useWhitespace && depth <= this.maxIndent - 1) {
            return this.nl(depth).i(depth);
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public SerializerWriter i(int indent) {
        if (this.useWhitespace && indent <= this.maxIndent) {
            for (int i = 0; i < indent; ++i) {
                this.w('\t');
            }
        }
        return this;
    }

    public SerializerWriter ie(int indent) {
        if (this.useWhitespace && indent <= this.maxIndent - 1) {
            for (int i = 0; i < indent; ++i) {
                this.w('\t');
            }
        }
        return this;
    }

    public SerializerWriter nl(int indent) {
        if (this.useWhitespace && indent <= this.maxIndent) {
            this.w('\n');
        }
        return this;
    }

    public SerializerWriter nlIf(boolean flag, int indent) {
        if (flag && this.useWhitespace && indent <= this.maxIndent) {
            this.w('\n');
        }
        return this;
    }

    public SerializerWriter q() {
        this.w(this.quoteChar);
        return this;
    }

    public SerializerWriter s() {
        if (this.useWhitespace) {
            this.w(' ');
        }
        return this;
    }

    public SerializerWriter sIf(boolean flag) {
        if (flag && !this.useWhitespace) {
            this.w(' ');
        }
        return this;
    }

    public SerializerWriter w(char value) {
        try {
            this.out.write(value);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    public SerializerWriter w(String value) {
        try {
            this.out.write(value);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        try {
            this.out.write(cbuf, off, len);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
    }

    private SerializerWriter append(int indent, boolean newline, String value) {
        if (value == null) {
            return this;
        }
        if (value.indexOf(10) != -1 && this.useWhitespace && indent <= this.maxIndent) {
            StringTokenizer st = new StringTokenizer(value, "\n");
            while (st.hasMoreTokens()) {
                this.i(indent).w(st.nextToken()).w("\n");
            }
        } else {
            this.i(indent).w(value);
        }
        if (newline) {
            this.nl(indent);
        }
        return this;
    }
}

