/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.juneau.annotation.SubItems;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.jsonschema.SchemaUtils;
import org.apache.juneau.parser.ParseException;

public class SubItemsAnnotation {
    public static final SubItems DEFAULT = SubItemsAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(SubItems a) {
        return a == null || DEFAULT.equals(a);
    }

    public static JsonMap merge(JsonMap om, SubItems a) throws ParseException {
        if (SubItemsAnnotation.empty(a)) {
            return om;
        }
        Predicate<String> ne = Utils::ne;
        Predicate<Collection> nec = Utils::ne;
        Predicate<Map> nem = Utils::ne;
        Predicate<Boolean> nf = Utils::isTrue;
        Predicate<Long> nm1 = Utils::nm1;
        return om.appendFirst(ne, "collectionFormat", a.collectionFormat(), a.cf()).appendIf(ne, "default", SchemaUtils.joinnl(a.default_(), a.df())).appendFirst(nec, "enum", SchemaUtils.parseSet(a.enum_()), SchemaUtils.parseSet(a.e())).appendIf(nf, "exclusiveMaximum", a.exclusiveMaximum() || a.emax()).appendIf(nf, "exclusiveMinimum", a.exclusiveMinimum() || a.emin()).appendFirst(ne, "format", a.format(), a.f()).appendIf(nem, "items", SchemaUtils.parseMap(a.items())).appendFirst(ne, "maximum", a.maximum(), a.max()).appendFirst(nm1, "maxItems", a.maxItems(), a.maxi()).appendFirst(nm1, "maxLength", a.maxLength(), a.maxl()).appendFirst(ne, "minimum", a.minimum(), a.min()).appendFirst(nm1, "minItems", a.minItems(), a.mini()).appendFirst(nm1, "minLength", a.minLength(), a.minl()).appendFirst(ne, "multipleOf", a.multipleOf(), a.mo()).appendFirst(ne, "pattern", a.pattern(), a.p()).appendFirst(ne, "type", a.type(), a.t()).appendIf(nf, "uniqueItems", a.uniqueItems() || a.ui()).appendIf(ne, "$ref", a.$ref());
    }

    public static class Builder
    extends AnnotationObject.Builder {
        private String[] description = new String[0];
        private String $ref = "";
        private String cf = "";
        private String collectionFormat = "";
        private String f = "";
        private String format = "";
        private String max = "";
        private String maximum = "";
        private String min = "";
        private String minimum = "";
        private String mo = "";
        private String multipleOf = "";
        private String p = "";
        private String pattern = "";
        private String t = "";
        private String type = "";
        private long maxItems = -1L;
        private long maxLength = -1L;
        private long maxi = -1L;
        private long maxl = -1L;
        private long minItems = -1L;
        private long minLength = -1L;
        private long mini = -1L;
        private long minl = -1L;
        private boolean emax;
        private boolean emin;
        private boolean exclusiveMaximum;
        private boolean exclusiveMinimum;
        private boolean ui;
        private boolean uniqueItems;
        private String[] default_ = new String[0];
        private String[] enum_ = new String[0];
        private String[] df = new String[0];
        private String[] e = new String[0];
        private String[] items = new String[0];

        protected Builder() {
            super(SubItems.class);
        }

        public Builder default_(String ... value) {
            this.default_ = value;
            return this;
        }

        public Builder enum_(String ... value) {
            this.enum_ = value;
            return this;
        }

        public Builder $ref(String value) {
            this.$ref = value;
            return this;
        }

        public SubItems build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder cf(String value) {
            this.cf = value;
            return this;
        }

        public Builder collectionFormat(String value) {
            this.collectionFormat = value;
            return this;
        }

        public Builder df(String ... value) {
            this.df = value;
            return this;
        }

        public Builder e(String ... value) {
            this.e = value;
            return this;
        }

        public Builder emax(boolean value) {
            this.emax = value;
            return this;
        }

        public Builder emin(boolean value) {
            this.emin = value;
            return this;
        }

        public Builder exclusiveMaximum(boolean value) {
            this.exclusiveMaximum = value;
            return this;
        }

        public Builder exclusiveMinimum(boolean value) {
            this.exclusiveMinimum = value;
            return this;
        }

        public Builder f(String value) {
            this.f = value;
            return this;
        }

        public Builder format(String value) {
            this.format = value;
            return this;
        }

        public Builder items(String ... value) {
            this.items = value;
            return this;
        }

        public Builder max(String value) {
            this.max = value;
            return this;
        }

        public Builder maxi(long value) {
            this.maxi = value;
            return this;
        }

        public Builder maximum(String value) {
            this.maximum = value;
            return this;
        }

        public Builder maxItems(long value) {
            this.maxItems = value;
            return this;
        }

        public Builder maxl(long value) {
            this.maxl = value;
            return this;
        }

        public Builder maxLength(long value) {
            this.maxLength = value;
            return this;
        }

        public Builder min(String value) {
            this.min = value;
            return this;
        }

        public Builder mini(long value) {
            this.mini = value;
            return this;
        }

        public Builder minimum(String value) {
            this.minimum = value;
            return this;
        }

        public Builder minItems(long value) {
            this.minItems = value;
            return this;
        }

        public Builder minl(long value) {
            this.minl = value;
            return this;
        }

        public Builder minLength(long value) {
            this.minLength = value;
            return this;
        }

        public Builder mo(String value) {
            this.mo = value;
            return this;
        }

        public Builder multipleOf(String value) {
            this.multipleOf = value;
            return this;
        }

        public Builder p(String value) {
            this.p = value;
            return this;
        }

        public Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public Builder t(String value) {
            this.t = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder ui(boolean value) {
            this.ui = value;
            return this;
        }

        public Builder uniqueItems(boolean value) {
            this.uniqueItems = value;
            return this;
        }
    }

    private static class Object
    extends AnnotationObject
    implements SubItems {
        private final String[] description;
        private final boolean emax;
        private final boolean emin;
        private final boolean exclusiveMaximum;
        private final boolean exclusiveMinimum;
        private final boolean ui;
        private final boolean uniqueItems;
        private final long maxi;
        private final long maxItems;
        private final long maxl;
        private final long maxLength;
        private final long mini;
        private final long minItems;
        private final long minl;
        private final long minLength;
        private final String $ref;
        private final String cf;
        private final String collectionFormat;
        private final String f;
        private final String format;
        private final String max;
        private final String maximum;
        private final String min;
        private final String minimum;
        private final String mo;
        private final String multipleOf;
        private final String p;
        private final String pattern;
        private final String t;
        private final String type;
        private final String[] default_;
        private final String[] enum_;
        private final String[] df;
        private final String[] e;
        private final String[] items;

        Object(Builder b) {
            super((AnnotationObject.Builder)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.$ref = b.$ref;
            this.default_ = (String[])CollectionUtils.copyOf((java.lang.Object[])b.default_);
            this.enum_ = (String[])CollectionUtils.copyOf((java.lang.Object[])b.enum_);
            this.cf = b.cf;
            this.collectionFormat = b.collectionFormat;
            this.df = (String[])CollectionUtils.copyOf((java.lang.Object[])b.df);
            this.e = (String[])CollectionUtils.copyOf((java.lang.Object[])b.e);
            this.emax = b.emax;
            this.emin = b.emin;
            this.exclusiveMaximum = b.exclusiveMaximum;
            this.exclusiveMinimum = b.exclusiveMinimum;
            this.f = b.f;
            this.format = b.format;
            this.items = (String[])CollectionUtils.copyOf((java.lang.Object[])b.items);
            this.max = b.max;
            this.maxi = b.maxi;
            this.maximum = b.maximum;
            this.maxItems = b.maxItems;
            this.maxl = b.maxl;
            this.maxLength = b.maxLength;
            this.min = b.min;
            this.mini = b.mini;
            this.minimum = b.minimum;
            this.minItems = b.minItems;
            this.minl = b.minl;
            this.minLength = b.minLength;
            this.mo = b.mo;
            this.multipleOf = b.multipleOf;
            this.p = b.p;
            this.pattern = b.pattern;
            this.t = b.t;
            this.type = b.type;
            this.ui = b.ui;
            this.uniqueItems = b.uniqueItems;
        }

        @Override
        public String[] default_() {
            return this.default_;
        }

        @Override
        public String[] enum_() {
            return this.enum_;
        }

        @Override
        public String $ref() {
            return this.$ref;
        }

        @Override
        public String cf() {
            return this.cf;
        }

        @Override
        public String collectionFormat() {
            return this.collectionFormat;
        }

        @Override
        public String[] df() {
            return this.df;
        }

        @Override
        public String[] e() {
            return this.e;
        }

        @Override
        public boolean emax() {
            return this.emax;
        }

        @Override
        public boolean emin() {
            return this.emin;
        }

        @Override
        public boolean exclusiveMaximum() {
            return this.exclusiveMaximum;
        }

        @Override
        public boolean exclusiveMinimum() {
            return this.exclusiveMinimum;
        }

        @Override
        public String f() {
            return this.f;
        }

        @Override
        public String format() {
            return this.format;
        }

        @Override
        public String[] items() {
            return this.items;
        }

        @Override
        public String max() {
            return this.max;
        }

        @Override
        public long maxi() {
            return this.maxi;
        }

        @Override
        public String maximum() {
            return this.maximum;
        }

        @Override
        public long maxItems() {
            return this.maxItems;
        }

        @Override
        public long maxl() {
            return this.maxl;
        }

        @Override
        public long maxLength() {
            return this.maxLength;
        }

        @Override
        public String min() {
            return this.min;
        }

        @Override
        public long mini() {
            return this.mini;
        }

        @Override
        public String minimum() {
            return this.minimum;
        }

        @Override
        public long minItems() {
            return this.minItems;
        }

        @Override
        public long minl() {
            return this.minl;
        }

        @Override
        public long minLength() {
            return this.minLength;
        }

        @Override
        public String mo() {
            return this.mo;
        }

        @Override
        public String multipleOf() {
            return this.multipleOf;
        }

        @Override
        public String p() {
            return this.p;
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public String t() {
            return this.t;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public boolean ui() {
            return this.ui;
        }

        @Override
        public boolean uniqueItems() {
            return this.uniqueItems;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }
}

