/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class SimpleMap<K, V>
extends AbstractMap<K, V> {
    final K[] keys;
    final V[] values;
    final SimpleUnmodifiableMapEntry[] entries;

    public SimpleMap(K[] keys, V[] values) {
        int i;
        AssertionUtils.assertArgsNotNull("keys", keys, "values", values);
        AssertionUtils.assertArg(keys.length == values.length, "keys ''{0}'' and values ''{1}'' array lengths differ", keys.length, values.length);
        for (i = 0; i < keys.length; ++i) {
            for (int j = i + 1; j < keys.length; ++j) {
                if (!Utils.eq(keys[i], keys[j])) continue;
                throw ThrowableUtils.illegalArg("Duplicate key found: {0}", keys[i]);
            }
        }
        this.keys = keys;
        this.values = values;
        this.entries = (SimpleUnmodifiableMapEntry[])Array.newInstance(SimpleUnmodifiableMapEntry.class, keys.length);
        for (i = 0; i < keys.length; ++i) {
            this.entries[i] = new SimpleUnmodifiableMapEntry(i);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(CollectionUtils.toSet(this.entries));
    }

    @Override
    public V get(Object key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!Utils.eq(this.keys[i], key)) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(CollectionUtils.toSet(this.keys));
    }

    @Override
    public V put(K key, V value) {
        throw ThrowableUtils.unsupportedOp("Map is unmodifiable", new Object[0]);
    }

    @Override
    public String toString() {
        return this.entrySet().stream().map(Object::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    @Override
    public boolean equals(Object o) {
        Map o2;
        return o instanceof Map && Utils.eq(this, o2 = (Map)o, (x, y) -> x.entrySet().equals(y.entrySet()));
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    class SimpleUnmodifiableMapEntry
    implements Map.Entry<K, V> {
        private final int index;

        SimpleUnmodifiableMapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return SimpleMap.this.keys[this.index];
        }

        @Override
        public V getValue() {
            return SimpleMap.this.values[this.index];
        }

        @Override
        public V setValue(V val) {
            throw ThrowableUtils.unsupportedOp("Map is unmodifiable", new Object[0]);
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry o2;
            return o instanceof Map.Entry && Utils.eq(this, o2 = (Map.Entry)o, (x, y) -> Utils.eq(x.getKey(), y.getKey()) && Utils.eq(x.getValue(), y.getValue()));
        }

        @Override
        public int hashCode() {
            Object key = this.getKey();
            Object value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }
}

