/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import java.util.function.Function;
import org.apache.jena.atlas.logging.FmtLog;
import org.slf4j.Logger;

public class PlatformInfo {
    public static final String prefix = "  ";
    public static final int nameFieldSize = 8;
    private static Function<Long, String> strMem = PlatformInfo::strMemNum2;

    public static void logInfo(Logger log2, String name, String valuesFmt, Object ... values) {
        PlatformInfo.logInfo(log2, 8, name, valuesFmt, values);
    }

    public static void logInfo(Logger log2, int fieldNameWidth, String name, String valuesFmt, Object ... values) {
        String fieldFmtStr = "%-" + fieldNameWidth + "s";
        String fieldStr = String.format(fieldFmtStr, name);
        String valuesStr = String.format(valuesFmt, values);
        FmtLog.info(log2, "%s%s%s", prefix, fieldStr, valuesStr);
    }

    public static void logSystemDetailsLong(Logger log2) {
        long maxMem = Runtime.getRuntime().maxMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        PlatformInfo.logInfo(log2, "Memory:", "%s", strMem.apply(maxMem));
        PlatformInfo.logInfo(log2, "Java:", "%s", System.getProperty("java.version"));
        PlatformInfo.logInfo(log2, "OS:", "%s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        PlatformInfo.logProcessOS(log2);
    }

    public static void logSystemDetailsShort(Logger log2) {
        long maxMem = Runtime.getRuntime().maxMemory();
        PlatformInfo.logInfo(log2, "Memory:", strMem.apply(maxMem), new Object[0]);
        PlatformInfo.logProcessOS(log2);
    }

    private static void logProcessOS(Logger log2) {
        long pid = PlatformInfo.getProcessId();
        if (pid != -1L) {
            PlatformInfo.logInfo(log2, "PID:", "%d", pid);
        }
    }

    public static void logDetailsJavaJVM(Logger log2) {
        String prefix = "    ";
        PlatformInfo.logOneJVM(log2, prefix, "java.vendor");
        PlatformInfo.logOneJVM(log2, prefix, "java.home");
        PlatformInfo.logOneJVM(log2, prefix, "java.runtime.version");
        PlatformInfo.logOneJVM(log2, prefix, "java.runtime.name");
    }

    public static void logDetailsUserJVM(Logger log2) {
        PlatformInfo.logOneJVM(log2, prefix, "user.language");
        PlatformInfo.logOneJVM(log2, prefix, "user.timezone");
        PlatformInfo.logOneJVM(log2, prefix, "user.country");
        PlatformInfo.logOneJVM(log2, prefix, "user.dir");
    }

    private static void logOneJVM(Logger log2, String prefix, String property) {
        if (prefix == null) {
            prefix = "";
        }
        PlatformInfo.logInfo(log2, 22, property, " = %s", System.getProperty(property));
    }

    private static long getProcessId() {
        return ProcessHandle.current().pid();
    }

    private static String strMemNum10(long x) {
        if (x < 1000L) {
            return Long.toString(x);
        }
        if (x < 1000000L) {
            return String.format("%.1fKB", (double)x / 1000.0);
        }
        if (x < 1000000000L) {
            return String.format("%.1fMB", (double)x / 1000000.0);
        }
        if (x < 1000000000000L) {
            return String.format("%.1fGB", (double)x / 1.0E9);
        }
        return String.format("%.1fTB", (double)x / 1.0E12);
    }

    private static String strMemNum2(long x) {
        if (x < 1024L) {
            return Long.toString(x);
        }
        if (x < 0x100000L) {
            return String.format("%.1f KiB", (double)x / 1024.0);
        }
        if (x < 0x40000000L) {
            return String.format("%.1f MiB", (double)x / 1048576.0);
        }
        if (x < 0x10000000000L) {
            return String.format("%.1f GiB", (double)x / 1.073741824E9);
        }
        return String.format("%.1fTiB", (double)x / 1.099511627776E12);
    }
}

