/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import org.apache.jena.fuseki.main.JettyServer;
import org.apache.jena.fuseki.main.sys.JettyLib;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttps {
    public static Server jettyServerHttps(ServletContextHandler handler, String keystore, String certPassword, int httpPort, int httpsPort) {
        return JettyHttps.jettyServerHttps(handler, keystore, certPassword, httpPort, httpsPort, -1, -1);
    }

    public static Server jettyServerHttps(ServletContextHandler handler, String keystore, String certPassword, int httpPort, int httpsPort, int minThreads, int maxThreads) {
        Server jettyServer = JettyHttps.server(keystore, certPassword, httpPort, httpsPort, minThreads, maxThreads);
        if (httpPort > 0) {
            SecuredRedirectHandler srh = new SecuredRedirectHandler();
            JettyLib.addHandler(jettyServer, srh);
        }
        JettyLib.addHandler(jettyServer, handler);
        return jettyServer;
    }

    private static Server server(String keystore, String certPassword, int httpPort, int httpsPort, int minThreads, int maxThreads) {
        Server server = JettyServer.jettyServer(minThreads, maxThreads);
        if (httpPort > 0) {
            ServerConnector plainConnector = JettyHttps.httpConnector(server, httpPort, httpsPort);
            server.addConnector(plainConnector);
        }
        ServerConnector httpsConnector = JettyHttps.httpsConnector(server, httpsPort, keystore, certPassword);
        server.addConnector(httpsConnector);
        return server;
    }

    private static ServerConnector httpConnector(Server server, int httpPort, int httpsPort) {
        HttpConfiguration http_config = JettyLib.httpConfiguration();
        http_config.setSendServerVersion(false);
        if (httpPort > 0) {
            http_config.setSecureScheme(HttpScheme.HTTPS.asString());
            http_config.setSecurePort(httpsPort);
        }
        ServerConnector plainConnector = new ServerConnector(server, new HttpConnectionFactory(http_config));
        plainConnector.setPort(httpPort);
        return plainConnector;
    }

    private static ServerConnector httpsConnector(Server server, int httpsPort, String keystore, String certPassword) {
        SslContextFactory.Server sslContextFactoryServer = new SslContextFactory.Server();
        sslContextFactoryServer.setKeyStorePath(keystore);
        sslContextFactoryServer.setKeyStorePassword(certPassword);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        HttpConfiguration https_config = JettyLib.httpConfiguration();
        https_config.setSecureScheme(HttpScheme.HTTPS.asString());
        https_config.setSecurePort(httpsPort);
        https_config.addCustomizer(src);
        ServerConnector sslConnector = new ServerConnector(server, new SslConnectionFactory(sslContextFactoryServer, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config));
        sslConnector.setPort(httpsPort);
        return sslConnector;
    }
}

