/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.PlanarGraph;
import org.locationtech.jts.planargraph.Subgraph;

public class ConnectedSubgraphFinder {
    private PlanarGraph graph;

    public ConnectedSubgraphFinder(PlanarGraph graph) {
        this.graph = graph;
    }

    public List getConnectedSubgraphs() {
        ArrayList<Subgraph> subgraphs = new ArrayList<Subgraph>();
        GraphComponent.setVisited(this.graph.nodeIterator(), false);
        Iterator i = this.graph.edgeIterator();
        while (i.hasNext()) {
            Edge e2 = (Edge)i.next();
            Node node = e2.getDirEdge(0).getFromNode();
            if (node.isVisited()) continue;
            subgraphs.add(this.findSubgraph(node));
        }
        return subgraphs;
    }

    private Subgraph findSubgraph(Node node) {
        Subgraph subgraph = new Subgraph(this.graph);
        this.addReachable(node, subgraph);
        return subgraph;
    }

    private void addReachable(Node startNode, Subgraph subgraph) {
        Stack<Node> nodeStack = new Stack<Node>();
        nodeStack.add(startNode);
        while (!nodeStack.empty()) {
            Node node = (Node)nodeStack.pop();
            this.addEdges(node, nodeStack, subgraph);
        }
    }

    private void addEdges(Node node, Stack nodeStack, Subgraph subgraph) {
        node.setVisited(true);
        Iterator<DirectedEdge> i = node.getOutEdges().iterator();
        while (i.hasNext()) {
            DirectedEdge de = i.next();
            subgraph.add(de.getEdge());
            Node toNode = de.getToNode();
            if (toNode.isVisited()) continue;
            nodeStack.push(toNode);
        }
    }
}

