/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.modify.request.Target;
import org.apache.jena.sparql.modify.request.UpdateAdd;
import org.apache.jena.sparql.modify.request.UpdateBinaryOp;
import org.apache.jena.sparql.modify.request.UpdateClear;
import org.apache.jena.sparql.modify.request.UpdateCopy;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDataWriter;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.sparql.modify.request.UpdateDropClear;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.modify.request.UpdateMove;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.serializer.FormatterElement;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.system.SinkQuadBracedOutput;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeToLabelMap;
import org.apache.jena.sparql.util.NodeToLabelMapBNode;

public class UpdateWriterVisitor
implements UpdateVisitor {
    protected static final int BLOCK_INDENT = 2;
    protected final IndentedWriter out;
    protected final SerializationContext sCxt;

    public UpdateWriterVisitor(IndentedWriter out, SerializationContext sCxt) {
        this.out = out;
        this.sCxt = sCxt;
    }

    protected void visitDropClear(String name, UpdateDropClear update2) {
        this.out.ensureStartOfLine();
        this.out.print(name);
        this.out.print(" ");
        if (update2.isSilent()) {
            this.out.print("SILENT ");
        }
        this.printTarget(update2.getTarget());
    }

    protected void printTarget(Target target) {
        if (target.isAll()) {
            this.out.print("ALL");
        } else if (target.isAllNamed()) {
            this.out.print("NAMED");
        } else if (target.isDefault()) {
            this.out.print("DEFAULT");
        } else if (target.isOneNamedGraph()) {
            this.out.print("GRAPH ");
            String s = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
            this.out.print(s);
        } else {
            this.out.print("Target BROKEN");
            throw new ARQException("Malformed Target");
        }
    }

    @Override
    public void visit(UpdateDrop update2) {
        this.visitDropClear("DROP", update2);
    }

    @Override
    public void visit(UpdateClear update2) {
        this.visitDropClear("CLEAR", update2);
    }

    @Override
    public void visit(UpdateCreate update2) {
        this.out.ensureStartOfLine();
        this.out.print("CREATE");
        this.out.print(" ");
        if (update2.isSilent()) {
            this.out.print("SILENT ");
        }
        this.out.print("GRAPH");
        this.out.print(" ");
        String s = FmtUtils.stringForNode(update2.getGraph(), this.sCxt);
        this.out.print(s);
    }

    @Override
    public void visit(UpdateLoad update2) {
        this.out.ensureStartOfLine();
        this.out.print("LOAD");
        this.out.print(" ");
        if (update2.isSilent()) {
            this.out.print("SILENT ");
        }
        this.outputStringAsURI(update2.getSource());
        if (update2.getDest() != null) {
            this.out.print(" INTO GRAPH ");
            this.output(update2.getDest());
        }
    }

    protected void outputStringAsURI(String uriStr) {
        String x = FmtUtils.stringForURI(uriStr, this.sCxt);
        this.out.print(x);
    }

    protected void printTargetUpdate2(Target target) {
        if (target.isDefault()) {
            this.out.print("DEFAULT");
        } else if (target.isOneNamedGraph()) {
            String s = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
            this.out.print(s);
        } else {
            this.out.print("Target BROKEN / Update2");
            throw new ARQException("Malformed Target / Update2");
        }
    }

    protected void printUpdate2(UpdateBinaryOp update2, String name) {
        this.out.print(name);
        if (update2.isSilent()) {
            this.out.print(" SILENT");
        }
        this.out.print(" ");
        this.printTargetUpdate2(update2.getSrc());
        this.out.print(" TO ");
        this.printTargetUpdate2(update2.getDest());
    }

    @Override
    public void visit(UpdateAdd update2) {
        this.printUpdate2(update2, "ADD");
    }

    @Override
    public void visit(UpdateCopy update2) {
        this.printUpdate2(update2, "COPY");
    }

    @Override
    public void visit(UpdateMove update2) {
        this.printUpdate2(update2, "MOVE");
    }

    @Override
    public void visit(UpdateDataInsert update2) {
        udw.open();
        try (UpdateDataWriter udw = new UpdateDataWriter(UpdateDataWriter.UpdateMode.INSERT, this.out, this.sCxt);){
            Iter.sendToSink(update2.getQuads().iterator(), udw);
        }
    }

    @Override
    public void visit(UpdateDataDelete update2) {
        udw.open();
        try (UpdateDataWriter udw = new UpdateDataWriter(UpdateDataWriter.UpdateMode.DELETE, this.out, this.sCxt);){
            Iter.sendToSink(update2.getQuads().iterator(), udw);
        }
    }

    protected void outputQuadsBraced(List<Quad> quads) {
        if (quads.size() == 0) {
            this.out.print("{ }");
            return;
        }
        SinkQuadBracedOutput sink = new SinkQuadBracedOutput(this.out, this.sCxt);
        sink.open();
        Iter.sendToSink(quads.iterator(), sink);
    }

    protected void output(Node node) {
        String $ = FmtUtils.stringForNode(node, this.sCxt);
        this.out.print($);
    }

    @Override
    public void visit(UpdateDeleteWhere update2) {
        this.out.ensureStartOfLine();
        this.out.println("DELETE WHERE ");
        this.outputQuadsBraced(update2.getQuads());
    }

    @Override
    public void visit(UpdateModify update2) {
        this.out.ensureStartOfLine();
        if (update2.getWithIRI() != null) {
            this.out.print("WITH ");
            this.output(update2.getWithIRI());
        }
        if (update2.hasDeleteClause()) {
            List<Quad> deleteQuads = update2.getDeleteQuads();
            this.out.ensureStartOfLine();
            this.out.print("DELETE ");
            this.outputQuadsBraced(deleteQuads);
        }
        if (update2.hasInsertClause()) {
            Iterator<Node> insertQuads = update2.getInsertQuads();
            this.out.ensureStartOfLine();
            this.out.print("INSERT ");
            this.outputQuadsBraced((List<Quad>)((Object)insertQuads));
        }
        if (!update2.hasInsertClause() && !update2.hasDeleteClause()) {
            this.out.ensureStartOfLine();
            this.out.println("INSERT { }");
        }
        for (Node x : update2.getUsing()) {
            this.out.ensureStartOfLine();
            this.out.print("USING ");
            this.output(x);
        }
        for (Node x : update2.getUsingNamed()) {
            this.out.ensureStartOfLine();
            this.out.print("USING NAMED ");
            this.output(x);
        }
        Element el = update2.getWherePattern();
        this.out.ensureStartOfLine();
        this.out.print("WHERE");
        this.out.incIndent(2);
        this.out.newline();
        if (el != null) {
            FormatterElement fmtElement = this.prepareElementFormatter();
            fmtElement.visitAsGroup(el);
        } else {
            this.out.print("{}");
        }
        this.out.decIndent(2);
    }

    protected FormatterElement prepareElementFormatter() {
        NodeToLabelMapBNode map2 = new NodeToLabelMapBNode("x", false);
        SerializationContext sCxt1 = new SerializationContext(this.sCxt, (NodeToLabelMap)map2);
        return new FormatterElement(this.out, sCxt1);
    }
}

