/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.Serializer;

public class Triple
implements Serializable {
    private final Node subj;
    private final Node pred;
    private final Node obj;
    public static final Triple ANY = new Triple(Node.ANY, Node.ANY, Node.ANY);

    protected Triple(Node s, Node p, Node o) {
        if (s == null) {
            throw new UnsupportedOperationException("subject cannot be null");
        }
        if (p == null) {
            throw new UnsupportedOperationException("predicate cannot be null");
        }
        if (o == null) {
            throw new UnsupportedOperationException("object cannot be null");
        }
        this.subj = s;
        this.pred = p;
        this.obj = o;
    }

    public String toString() {
        return this.toString(PrefixMapping.Standard);
    }

    public String toString(PrefixMapping pm) {
        return this.stringForNode(pm, this.subj) + " " + this.stringForNode(pm, this.pred) + " " + this.stringForNode(pm, this.obj);
    }

    private String stringForNode(PrefixMapping pm, Node node) {
        if (node.isURI()) {
            String x;
            if (pm != null && (x = pm.shortForm(node.getURI())) != null) {
                return x;
            }
            return "<" + node.getURI() + ">";
        }
        if (node.isLiteral()) {
            return node.getLiteral().toString(pm, true);
        }
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel();
        }
        return node.toString();
    }

    public final Node getSubject() {
        return this.subj;
    }

    public final Node getPredicate() {
        return this.pred;
    }

    public final Node getObject() {
        return this.obj;
    }

    public Node getMatchSubject() {
        return Triple.anyToNull(this.subj);
    }

    public Node getMatchPredicate() {
        return Triple.anyToNull(this.pred);
    }

    public Node getMatchObject() {
        return Triple.anyToNull(this.obj);
    }

    private static Node anyToNull(Node n) {
        return Node.ANY.equals(n) ? null : n;
    }

    private static Node nullToAny(Node n) {
        return n == null ? Node.ANY : n;
    }

    private static boolean isAny(Node n) {
        return n == null || Node.ANY.equals(n);
    }

    public boolean isConcrete() {
        return this.subj.isConcrete() && this.pred.isConcrete() && this.obj.isConcrete();
    }

    public boolean equals(Object o) {
        return o instanceof Triple && ((Triple)o).sameAs(this.subj, this.pred, this.obj);
    }

    public boolean sameAs(Node s, Node p, Node o) {
        return this.subj.equals(s) && this.pred.equals(p) && this.obj.equals(o);
    }

    public boolean matches(Triple other) {
        return other.matchedBy(this.subj, this.pred, this.obj);
    }

    public boolean matches(Node s, Node p, Node o) {
        return this.subj.matches(s) && this.pred.matches(p) && this.obj.matches(o);
    }

    private boolean matchedBy(Node s, Node p, Node o) {
        return s.matches(this.subj) && p.matches(this.pred) && o.matches(this.obj);
    }

    public boolean subjectMatches(Node s) {
        return this.subj.matches(s);
    }

    public boolean predicateMatches(Node p) {
        return this.pred.matches(p);
    }

    public boolean objectMatches(Node o) {
        return this.obj.matches(o);
    }

    protected Object writeReplace() throws ObjectStreamException {
        Function<Triple, Object> function = Serializer.getTripleSerializer();
        if (function == null) {
            throw new IllegalStateException("Function for Triple.writeReplace not set");
        }
        return function.apply(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IllegalStateException();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException();
    }

    public int hashCode() {
        return Triple.hashCode(this.subj, this.pred, this.obj);
    }

    public static int hashCode(Node s, Node p, Node o) {
        return s.hashCode() >> 1 ^ p.hashCode() ^ o.hashCode() << 1;
    }

    public static Triple create(Node s, Node p, Node o) {
        if (Triple.isAny(s) && Triple.isAny(p) && Triple.isAny(o)) {
            return ANY;
        }
        return new Triple(s, p, o);
    }

    public static Triple createMatch(Node s, Node p, Node o) {
        return Triple.create(Triple.nullToAny(s), Triple.nullToAny(p), Triple.nullToAny(o));
    }

    public static abstract class Field {
        protected static final Predicate<Triple> anyTriple = t -> true;
        public static final Field fieldSubject = new Field(){

            @Override
            public Node getField(Triple t) {
                return t.subj;
            }

            @Override
            public Predicate<Triple> filterOn(Node n) {
                return n.isConcrete() ? x -> n.equals(x.subj) : anyTriple;
            }

            @Override
            public Predicate<Triple> filterOnConcrete(Node n) {
                return x -> n.equals(x.subj);
            }
        };
        public static final Field fieldObject = new Field(){

            @Override
            public Node getField(Triple t) {
                return t.obj;
            }

            @Override
            public Predicate<Triple> filterOn(Node n) {
                return n.isConcrete() ? x -> n.sameValueAs(x.obj) : anyTriple;
            }

            @Override
            public Predicate<Triple> filterOnConcrete(Node n) {
                return x -> n.sameValueAs(x.obj);
            }
        };
        public static final Field fieldPredicate = new Field(){

            @Override
            public Node getField(Triple t) {
                return t.pred;
            }

            @Override
            public Predicate<Triple> filterOn(Node n) {
                return n.isConcrete() ? x -> n.equals(x.pred) : anyTriple;
            }

            @Override
            public Predicate<Triple> filterOnConcrete(Node n) {
                return x -> n.equals(x.pred);
            }
        };

        public abstract Node getField(Triple var1);

        public abstract Predicate<Triple> filterOn(Node var1);

        public abstract Predicate<Triple> filterOnConcrete(Node var1);

        public final Predicate<Triple> filterOn(Triple t) {
            return this.filterOn(this.getField(t));
        }
    }
}

