/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog.rotate;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.jena.rdfpatch.filelog.rotate.FileMgr;
import org.apache.jena.rdfpatch.filelog.rotate.Filename;
import org.apache.jena.rdfpatch.filelog.rotate.Roller;

class RollerShifter
implements Roller {
    private boolean valid = false;
    private final Path directory;
    private final String baseFilename;
    private final Path filename;
    private Path currentFilename;
    private static Pattern patternIncremental = FileMgr.patternIncremental;
    private static final String INC_SEP = ".";
    private static final String numFmt = "%d";
    private static final Comparator<Filename> cmpNumericModifier = FileMgr.cmpNumericModifier;

    RollerShifter(Path directory, String baseFilename, String format) {
        this.directory = directory;
        this.baseFilename = baseFilename;
        this.filename = directory.resolve(baseFilename);
        this.init(directory, baseFilename);
    }

    private void init(Path directory, String baseFilename) {
        List<Filename> filenames = FileMgr.scan(directory, baseFilename, patternIncremental);
        this.currentFilename = filenames.isEmpty() ? null : this.filename;
    }

    @Override
    public Stream<Filename> files() {
        List<Filename> filenames = FileMgr.scan(this.directory, this.baseFilename, patternIncremental);
        Collections.sort(filenames, cmpNumericModifier);
        if (Files.exists(this.filename, new LinkOption[0])) {
            Filename base = new Filename(this.directory, this.baseFilename, null, null, null);
            filenames.add(base);
        }
        return filenames.stream();
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public void startSection() {
    }

    @Override
    public void finishSection() {
    }

    @Override
    public Path latestFilename() {
        return this.currentFilename;
    }

    @Override
    public void rotate() {
        this.valid = false;
    }

    @Override
    public boolean hasExpired() {
        return !this.valid;
    }

    @Override
    public Path nextFilename() {
        this.valid = true;
        FileMgr.shiftFiles(this.directory, this.baseFilename, 1, "%03d");
        this.currentFilename = this.filename;
        return this.filename;
    }
}

