/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.io.InputStreams;
import org.junit.Assert;
import org.junit.Test;

public class QuotedPrintableInputStreamTest {
    private static String readText(InputStream is) throws IOException {
        return IOUtils.toString((InputStream)is, (String)Charsets.ISO_8859_1.name());
    }

    private static String readTextByOne(InputStream is) throws IOException {
        int ch;
        StringBuilder buf = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(is, Charsets.ISO_8859_1.name());
        while ((ch = ((Reader)reader).read()) != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }

    @Test
    public void testBasicDecode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"=e1=e2=E3=E4\r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"\u00e1\u00e2\u00e3\u00e4\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodeBufferWrapping() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"=e1=e2=E3=E4\r\n=e1=e2=E3=E4\r\n=e1=e2=E3=E4\r\n=e1=e2=E3=E4\r\n=e1=e2=E3=E4\r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"\u00e1\u00e2\u00e3\u00e4\r\n\u00e1\u00e2\u00e3\u00e4\r\n\u00e1\u00e2\u00e3\u00e4\r\n\u00e1\u00e2\u00e3\u00e4\r\n\u00e1\u00e2\u00e3\u00e4\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testInvalidValueDecode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"=e1=g2=E3=E4\r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"\u00e1=g2\u00e3\u00e4\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodeTrailingBlanks() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"   =e1 =e2  =E3\t=E4  \t \t    \r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"   \u00e1 \u00e2  \u00e3\t\u00e4\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testCanonicalSoftBreakDecode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"Soft line   =\r\nHard line   \r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"Soft line   Hard line\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testSoftBreakStrictMode() throws IOException {
        String input = "<?xml version=3D\"1.0\" standalone=3D\"no\"?>\r\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/=\r\nSVG/1.1/DTD/svg11.dtd\" >\r\n";
        String expected = "<?xml version=\"1.0\" standalone=\"no\"?>\r\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\" >\r\n";
        InputStream bis = InputStreams.createAscii((CharSequence)input);
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis, DecodeMonitor.STRICT);
        Assert.assertEquals((Object)expected, (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testInvalidCR() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"Invalid=\rCR\rHard line   \r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"Invalid=\rCR\rHard line\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testInvalidCRStrictMode() throws IOException {
        InputStream bis = InputStreams.createAscii((CharSequence)"Invalid=\rCR\rHard line   \r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis, DecodeMonitor.STRICT);
        try {
            QuotedPrintableInputStreamTest.readText((InputStream)decoder);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSoftBreakLoneLFDecode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"Soft line   =\nHard line   \r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"Soft line   Hard line\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testSpaceBeforeSoftBreakStrictMode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"text before eq sign =\r\n text after LF");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis, DecodeMonitor.STRICT);
        Assert.assertEquals((Object)"text before eq sign  text after LF", (Object)QuotedPrintableInputStreamTest.readTextByOne((InputStream)decoder));
    }

    @Test
    public void testSoftBreakTrailingBalnksDecode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"Soft line   = \t \r\nHard line   \r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"Soft line   Hard line\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testBrokenSoftBreakDecode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"Soft line   =\rHard line   \r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"Soft line   =\rHard line\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testEscapedEQDecode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"width==340 height=3d200\r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"width=340 height=200\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testBrokenEscapedEQDecode() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"width==\r\n340 height=3d200\r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"width=340 height=200\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testSpacesBeforeEOL() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"some \r\n spaced\t\r\ncontent \t \r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((Object)"some\r\n spaced\r\ncontent\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodeEndOfStream1() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"01234567");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(6, bis, false);
        Assert.assertEquals((Object)"01234567", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodeEndOfStream2() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"012345\r");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(6, bis, false);
        Assert.assertEquals((Object)"012345", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodeEndOfStream3() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"012345\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(6, bis, false);
        Assert.assertEquals((Object)"012345\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodeEndOfStream4() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"01234= ");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(6, bis, false);
        Assert.assertEquals((Object)"01234", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodeEndOfStream5() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"01234=\r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(6, bis, false);
        Assert.assertEquals((Object)"01234", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodeEndOfStream6() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"01234\r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(6, bis, false);
        Assert.assertEquals((Object)"01234\r\n", (Object)QuotedPrintableInputStreamTest.readText((InputStream)decoder));
    }

    @Test
    public void testDecodePrematureClose() throws IOException, UnsupportedEncodingException {
        InputStream bis = InputStreams.createAscii((CharSequence)"=e1=e2=E3=E4\r\n");
        QuotedPrintableInputStream decoder = new QuotedPrintableInputStream(bis);
        Assert.assertEquals((long)225L, (long)decoder.read());
        Assert.assertEquals((long)226L, (long)decoder.read());
        decoder.close();
        try {
            decoder.read();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

