/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.enums.TSDataType;

public class DataTypeFilter
extends SchemaFilter {
    private final TSDataType dataType;

    public DataTypeFilter(TSDataType dataType) {
        this.dataType = dataType;
    }

    public DataTypeFilter(ByteBuffer byteBuffer) {
        this.dataType = TSDataType.deserializeFrom((ByteBuffer)byteBuffer);
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    @Override
    public <C> Boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitDataTypeFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.DATA_TYPE;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        this.dataType.serializeTo(byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        this.dataType.serializeTo(stream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTypeFilter that = (DataTypeFilter)o;
        return Objects.equals(this.dataType, that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.dataType);
    }
}

